package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  TagValue,
  AccessLogDestinationArn,
  ResourceIdentifier,
  ClientToken,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAccessLogSubscriptionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    destinationArn: AccessLogDestinationArn,
    resourceIdentifier: ResourceIdentifier,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionRequest = {
    import CreateAccessLogSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .destinationArn(
        AccessLogDestinationArn.unwrap(destinationArn): java.lang.String
      )
      .resourceIdentifier(
        ResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.CreateAccessLogSubscriptionRequest.ReadOnly =
    zio.aws.vpclattice.model.CreateAccessLogSubscriptionRequest
      .wrap(buildAwsValue())
}
object CreateAccessLogSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.vpclattice.model.CreateAccessLogSubscriptionRequest =
      zio.aws.vpclattice.model.CreateAccessLogSubscriptionRequest(
        clientToken.map(value => value),
        destinationArn,
        resourceIdentifier,
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def destinationArn: AccessLogDestinationArn
    def resourceIdentifier: ResourceIdentifier
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDestinationArn: ZIO[Any, Nothing, AccessLogDestinationArn] =
      ZIO.succeed(destinationArn)
    def getResourceIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionRequest
  ) extends zio.aws.vpclattice.model.CreateAccessLogSubscriptionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.vpclattice.model.primitives.ClientToken(value))
    override val destinationArn: AccessLogDestinationArn =
      zio.aws.vpclattice.model.primitives
        .AccessLogDestinationArn(impl.destinationArn())
    override val resourceIdentifier: ResourceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ResourceIdentifier(impl.resourceIdentifier())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.vpclattice.model.primitives.TagKey(
              key
            ) -> zio.aws.vpclattice.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionRequest
  ): zio.aws.vpclattice.model.CreateAccessLogSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
