package zio.aws.vpclattice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchUpdateRuleResponse(
    successful: Optional[Iterable[zio.aws.vpclattice.model.RuleUpdateSuccess]] =
      Optional.Absent,
    unsuccessful: Optional[
      Iterable[zio.aws.vpclattice.model.RuleUpdateFailure]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleResponse = {
    import BatchUpdateRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleResponse
      .builder()
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successful)
      .optionallyWith(
        unsuccessful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessful)
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.BatchUpdateRuleResponse.ReadOnly =
    zio.aws.vpclattice.model.BatchUpdateRuleResponse.wrap(buildAwsValue())
}
object BatchUpdateRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.BatchUpdateRuleResponse =
      zio.aws.vpclattice.model.BatchUpdateRuleResponse(
        successful.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsuccessful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successful
        : Optional[List[zio.aws.vpclattice.model.RuleUpdateSuccess.ReadOnly]]
    def unsuccessful
        : Optional[List[zio.aws.vpclattice.model.RuleUpdateFailure.ReadOnly]]
    def getSuccessful: ZIO[Any, AwsError, List[
      zio.aws.vpclattice.model.RuleUpdateSuccess.ReadOnly
    ]] = AwsError.unwrapOptionField("successful", successful)
    def getUnsuccessful: ZIO[Any, AwsError, List[
      zio.aws.vpclattice.model.RuleUpdateFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("unsuccessful", unsuccessful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleResponse
  ) extends zio.aws.vpclattice.model.BatchUpdateRuleResponse.ReadOnly {
    override val successful
        : Optional[List[zio.aws.vpclattice.model.RuleUpdateSuccess.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successful())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.RuleUpdateSuccess.wrap(item)
          }.toList
        )
    override val unsuccessful
        : Optional[List[zio.aws.vpclattice.model.RuleUpdateFailure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unsuccessful())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.vpclattice.model.RuleUpdateFailure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleResponse
  ): zio.aws.vpclattice.model.BatchUpdateRuleResponse.ReadOnly = new Wrapper(
    impl
  )
}
