package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  ServiceIdentifier,
  ListenerIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchUpdateRuleRequest(
    listenerIdentifier: ListenerIdentifier,
    rules: Iterable[zio.aws.vpclattice.model.RuleUpdate],
    serviceIdentifier: ServiceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleRequest = {
    import BatchUpdateRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleRequest
      .builder()
      .listenerIdentifier(
        ListenerIdentifier.unwrap(listenerIdentifier): java.lang.String
      )
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .serviceIdentifier(
        ServiceIdentifier.unwrap(serviceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.vpclattice.model.BatchUpdateRuleRequest.ReadOnly =
    zio.aws.vpclattice.model.BatchUpdateRuleRequest.wrap(buildAwsValue())
}
object BatchUpdateRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.BatchUpdateRuleRequest =
      zio.aws.vpclattice.model.BatchUpdateRuleRequest(
        listenerIdentifier,
        rules.map { item =>
          item.asEditable
        },
        serviceIdentifier
      )
    def listenerIdentifier: ListenerIdentifier
    def rules: List[zio.aws.vpclattice.model.RuleUpdate.ReadOnly]
    def serviceIdentifier: ServiceIdentifier
    def getListenerIdentifier: ZIO[Any, Nothing, ListenerIdentifier] =
      ZIO.succeed(listenerIdentifier)
    def getRules: ZIO[Any, Nothing, List[
      zio.aws.vpclattice.model.RuleUpdate.ReadOnly
    ]] = ZIO.succeed(rules)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceIdentifier] =
      ZIO.succeed(serviceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleRequest
  ) extends zio.aws.vpclattice.model.BatchUpdateRuleRequest.ReadOnly {
    override val listenerIdentifier: ListenerIdentifier =
      zio.aws.vpclattice.model.primitives
        .ListenerIdentifier(impl.listenerIdentifier())
    override val rules: List[zio.aws.vpclattice.model.RuleUpdate.ReadOnly] =
      impl
        .rules()
        .asScala
        .map { item =>
          zio.aws.vpclattice.model.RuleUpdate.wrap(item)
        }
        .toList
    override val serviceIdentifier: ServiceIdentifier =
      zio.aws.vpclattice.model.primitives
        .ServiceIdentifier(impl.serviceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleRequest
  ): zio.aws.vpclattice.model.BatchUpdateRuleRequest.ReadOnly = new Wrapper(
    impl
  )
}
