package zio.aws.vpclattice.model
import scala.jdk.CollectionConverters.*
sealed trait AuthType {
  def unwrap: software.amazon.awssdk.services.vpclattice.model.AuthType
}
object AuthType {
  def wrap(
      value: software.amazon.awssdk.services.vpclattice.model.AuthType
  ): zio.aws.vpclattice.model.AuthType = value match {
    case software.amazon.awssdk.services.vpclattice.model.AuthType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.vpclattice.model.AuthType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.vpclattice.model.AuthType.AWS_IAM =>
      val r = AWS_IAM
      r
  }
  case object unknownToSdkVersion extends zio.aws.vpclattice.model.AuthType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.AuthType =
      software.amazon.awssdk.services.vpclattice.model.AuthType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.vpclattice.model.AuthType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.AuthType =
      software.amazon.awssdk.services.vpclattice.model.AuthType.NONE
  }
  case object AWS_IAM extends zio.aws.vpclattice.model.AuthType {
    override def unwrap
        : software.amazon.awssdk.services.vpclattice.model.AuthType =
      software.amazon.awssdk.services.vpclattice.model.AuthType.AWS_IAM
  }
}
