package zio.aws.vpclattice.model
import zio.aws.vpclattice.model.primitives.{
  Timestamp,
  AccessLogDestinationArn,
  ResourceArn,
  AccessLogSubscriptionArn,
  ResourceId,
  AccessLogSubscriptionId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AccessLogSubscriptionSummary(
    arn: AccessLogSubscriptionArn,
    createdAt: Timestamp,
    destinationArn: AccessLogDestinationArn,
    id: AccessLogSubscriptionId,
    lastUpdatedAt: Timestamp,
    resourceArn: ResourceArn,
    resourceId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.vpclattice.model.AccessLogSubscriptionSummary = {
    import AccessLogSubscriptionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.vpclattice.model.AccessLogSubscriptionSummary
      .builder()
      .arn(AccessLogSubscriptionArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .destinationArn(
        AccessLogDestinationArn.unwrap(destinationArn): java.lang.String
      )
      .id(AccessLogSubscriptionId.unwrap(id): java.lang.String)
      .lastUpdatedAt(Timestamp.unwrap(lastUpdatedAt): Instant)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.vpclattice.model.AccessLogSubscriptionSummary.ReadOnly =
    zio.aws.vpclattice.model.AccessLogSubscriptionSummary.wrap(buildAwsValue())
}
object AccessLogSubscriptionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.vpclattice.model.AccessLogSubscriptionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.vpclattice.model.AccessLogSubscriptionSummary =
      zio.aws.vpclattice.model.AccessLogSubscriptionSummary(
        arn,
        createdAt,
        destinationArn,
        id,
        lastUpdatedAt,
        resourceArn,
        resourceId
      )
    def arn: AccessLogSubscriptionArn
    def createdAt: Timestamp
    def destinationArn: AccessLogDestinationArn
    def id: AccessLogSubscriptionId
    def lastUpdatedAt: Timestamp
    def resourceArn: ResourceArn
    def resourceId: ResourceId
    def getArn: ZIO[Any, Nothing, AccessLogSubscriptionArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDestinationArn: ZIO[Any, Nothing, AccessLogDestinationArn] =
      ZIO.succeed(destinationArn)
    def getId: ZIO[Any, Nothing, AccessLogSubscriptionId] = ZIO.succeed(id)
    def getLastUpdatedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedAt)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.vpclattice.model.AccessLogSubscriptionSummary
  ) extends zio.aws.vpclattice.model.AccessLogSubscriptionSummary.ReadOnly {
    override val arn: AccessLogSubscriptionArn =
      zio.aws.vpclattice.model.primitives.AccessLogSubscriptionArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.vpclattice.model.primitives.Timestamp(impl.createdAt())
    override val destinationArn: AccessLogDestinationArn =
      zio.aws.vpclattice.model.primitives
        .AccessLogDestinationArn(impl.destinationArn())
    override val id: AccessLogSubscriptionId =
      zio.aws.vpclattice.model.primitives.AccessLogSubscriptionId(impl.id())
    override val lastUpdatedAt: Timestamp =
      zio.aws.vpclattice.model.primitives.Timestamp(impl.lastUpdatedAt())
    override val resourceArn: ResourceArn =
      zio.aws.vpclattice.model.primitives.ResourceArn(impl.resourceArn())
    override val resourceId: ResourceId =
      zio.aws.vpclattice.model.primitives.ResourceId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.vpclattice.model.AccessLogSubscriptionSummary
  ): zio.aws.vpclattice.model.AccessLogSubscriptionSummary.ReadOnly =
    new Wrapper(impl)
}
