package zio.aws.vpclattice
import zio.aws.vpclattice.model.DeleteRuleResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.vpclattice.model.{
  CreateServiceNetworkRequest,
  ListAccessLogSubscriptionsRequest,
  GetAccessLogSubscriptionRequest,
  GetServiceNetworkRequest,
  ListListenersRequest,
  DeleteServiceRequest,
  GetListenerRequest,
  CreateServiceNetworkVpcAssociationRequest,
  RegisterTargetsRequest,
  ListRulesRequest,
  GetRuleRequest,
  ListServiceNetworkServiceAssociationsRequest,
  DeleteAccessLogSubscriptionRequest,
  PutResourcePolicyRequest,
  UpdateTargetGroupRequest,
  GetTargetGroupRequest,
  CreateServiceNetworkServiceAssociationRequest,
  ListTagsForResourceRequest,
  ListTargetsRequest,
  ListTargetGroupsRequest,
  BatchUpdateRuleRequest,
  DeregisterTargetsRequest,
  DeleteServiceNetworkServiceAssociationRequest,
  CreateRuleRequest,
  CreateServiceRequest,
  DeleteServiceNetworkRequest,
  DeleteRuleRequest,
  DeleteAuthPolicyRequest,
  UpdateListenerRequest,
  PutAuthPolicyRequest,
  CreateAccessLogSubscriptionRequest,
  ListServiceNetworksRequest,
  GetServiceNetworkServiceAssociationRequest,
  DeleteResourcePolicyRequest,
  GetServiceRequest,
  UpdateAccessLogSubscriptionRequest,
  UntagResourceRequest,
  GetAuthPolicyRequest,
  CreateTargetGroupRequest,
  ListServiceNetworkVpcAssociationsRequest,
  ListServicesRequest,
  DeleteServiceNetworkVpcAssociationRequest,
  UpdateServiceNetworkRequest,
  UpdateRuleRequest,
  DeleteListenerRequest,
  CreateListenerRequest,
  GetResourcePolicyRequest,
  DeleteTargetGroupRequest,
  GetServiceNetworkVpcAssociationRequest,
  UpdateServiceRequest,
  UpdateServiceNetworkVpcAssociationRequest,
  TagResourceRequest
}
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient
import zio.stream.ZStream
object VpcLatticeMock extends Mock[VpcLattice] {
  object DeleteTargetGroup
      extends Effect[
        DeleteTargetGroupRequest,
        AwsError,
        zio.aws.vpclattice.model.DeleteTargetGroupResponse.ReadOnly
      ]
  object UpdateServiceNetworkVpcAssociation
      extends Effect[
        UpdateServiceNetworkVpcAssociationRequest,
        AwsError,
        zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationResponse.ReadOnly
      ]
  object ListServiceNetworkVpcAssociations
      extends Stream[
        ListServiceNetworkVpcAssociationsRequest,
        AwsError,
        zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary.ReadOnly
      ]
  object ListServiceNetworkVpcAssociationsPaginated
      extends Effect[
        ListServiceNetworkVpcAssociationsRequest,
        AwsError,
        zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse.ReadOnly
      ]
  object ListTargets
      extends Stream[
        ListTargetsRequest,
        AwsError,
        zio.aws.vpclattice.model.TargetSummary.ReadOnly
      ]
  object ListTargetsPaginated
      extends Effect[
        ListTargetsRequest,
        AwsError,
        zio.aws.vpclattice.model.ListTargetsResponse.ReadOnly
      ]
  object CreateService
      extends Effect[
        CreateServiceRequest,
        AwsError,
        zio.aws.vpclattice.model.CreateServiceResponse.ReadOnly
      ]
  object GetServiceNetwork
      extends Effect[
        GetServiceNetworkRequest,
        AwsError,
        zio.aws.vpclattice.model.GetServiceNetworkResponse.ReadOnly
      ]
  object BatchUpdateRule
      extends Effect[
        BatchUpdateRuleRequest,
        AwsError,
        zio.aws.vpclattice.model.BatchUpdateRuleResponse.ReadOnly
      ]
  object DeregisterTargets
      extends Effect[
        DeregisterTargetsRequest,
        AwsError,
        zio.aws.vpclattice.model.DeregisterTargetsResponse.ReadOnly
      ]
  object UpdateAccessLogSubscription
      extends Effect[
        UpdateAccessLogSubscriptionRequest,
        AwsError,
        zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse.ReadOnly
      ]
  object GetAuthPolicy
      extends Effect[
        GetAuthPolicyRequest,
        AwsError,
        zio.aws.vpclattice.model.GetAuthPolicyResponse.ReadOnly
      ]
  object DeleteListener
      extends Effect[
        DeleteListenerRequest,
        AwsError,
        zio.aws.vpclattice.model.DeleteListenerResponse.ReadOnly
      ]
  object DeleteService
      extends Effect[
        DeleteServiceRequest,
        AwsError,
        zio.aws.vpclattice.model.DeleteServiceResponse.ReadOnly
      ]
  object CreateServiceNetworkServiceAssociation
      extends Effect[
        CreateServiceNetworkServiceAssociationRequest,
        AwsError,
        zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse.ReadOnly
      ]
  object ListServices
      extends Stream[
        ListServicesRequest,
        AwsError,
        zio.aws.vpclattice.model.ServiceSummary.ReadOnly
      ]
  object ListServicesPaginated
      extends Effect[
        ListServicesRequest,
        AwsError,
        zio.aws.vpclattice.model.ListServicesResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.vpclattice.model.PutResourcePolicyResponse.ReadOnly
      ]
  object ListServiceNetworkServiceAssociations
      extends Stream[
        ListServiceNetworkServiceAssociationsRequest,
        AwsError,
        zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary.ReadOnly
      ]
  object ListServiceNetworkServiceAssociationsPaginated
      extends Effect[
        ListServiceNetworkServiceAssociationsRequest,
        AwsError,
        zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsResponse.ReadOnly
      ]
  object DeleteServiceNetworkVpcAssociation
      extends Effect[
        DeleteServiceNetworkVpcAssociationRequest,
        AwsError,
        zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse.ReadOnly
      ]
  object DeleteRule extends Effect[DeleteRuleRequest, AwsError, ReadOnly]
  object RegisterTargets
      extends Effect[
        RegisterTargetsRequest,
        AwsError,
        zio.aws.vpclattice.model.RegisterTargetsResponse.ReadOnly
      ]
  object ListAccessLogSubscriptions
      extends Stream[
        ListAccessLogSubscriptionsRequest,
        AwsError,
        zio.aws.vpclattice.model.AccessLogSubscriptionSummary.ReadOnly
      ]
  object ListAccessLogSubscriptionsPaginated
      extends Effect[
        ListAccessLogSubscriptionsRequest,
        AwsError,
        zio.aws.vpclattice.model.ListAccessLogSubscriptionsResponse.ReadOnly
      ]
  object GetAccessLogSubscription
      extends Effect[
        GetAccessLogSubscriptionRequest,
        AwsError,
        zio.aws.vpclattice.model.GetAccessLogSubscriptionResponse.ReadOnly
      ]
  object GetListener
      extends Effect[
        GetListenerRequest,
        AwsError,
        zio.aws.vpclattice.model.GetListenerResponse.ReadOnly
      ]
  object CreateTargetGroup
      extends Effect[
        CreateTargetGroupRequest,
        AwsError,
        zio.aws.vpclattice.model.CreateTargetGroupResponse.ReadOnly
      ]
  object CreateListener
      extends Effect[
        CreateListenerRequest,
        AwsError,
        zio.aws.vpclattice.model.CreateListenerResponse.ReadOnly
      ]
  object UpdateRule
      extends Effect[
        UpdateRuleRequest,
        AwsError,
        zio.aws.vpclattice.model.UpdateRuleResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.vpclattice.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteAccessLogSubscription
      extends Effect[
        DeleteAccessLogSubscriptionRequest,
        AwsError,
        zio.aws.vpclattice.model.DeleteAccessLogSubscriptionResponse.ReadOnly
      ]
  object ListTargetGroups
      extends Stream[
        ListTargetGroupsRequest,
        AwsError,
        zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly
      ]
  object ListTargetGroupsPaginated
      extends Effect[
        ListTargetGroupsRequest,
        AwsError,
        zio.aws.vpclattice.model.ListTargetGroupsResponse.ReadOnly
      ]
  object DeleteResourcePolicy
      extends Effect[
        DeleteResourcePolicyRequest,
        AwsError,
        zio.aws.vpclattice.model.DeleteResourcePolicyResponse.ReadOnly
      ]
  object GetService
      extends Effect[
        GetServiceRequest,
        AwsError,
        zio.aws.vpclattice.model.GetServiceResponse.ReadOnly
      ]
  object CreateServiceNetwork
      extends Effect[
        CreateServiceNetworkRequest,
        AwsError,
        zio.aws.vpclattice.model.CreateServiceNetworkResponse.ReadOnly
      ]
  object UpdateTargetGroup
      extends Effect[
        UpdateTargetGroupRequest,
        AwsError,
        zio.aws.vpclattice.model.UpdateTargetGroupResponse.ReadOnly
      ]
  object GetServiceNetworkServiceAssociation
      extends Effect[
        GetServiceNetworkServiceAssociationRequest,
        AwsError,
        zio.aws.vpclattice.model.GetServiceNetworkServiceAssociationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.vpclattice.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.vpclattice.model.TagResourceResponse.ReadOnly
      ]
  object UpdateListener
      extends Effect[
        UpdateListenerRequest,
        AwsError,
        zio.aws.vpclattice.model.UpdateListenerResponse.ReadOnly
      ]
  object ListRules
      extends Stream[
        ListRulesRequest,
        AwsError,
        zio.aws.vpclattice.model.RuleSummary.ReadOnly
      ]
  object ListRulesPaginated
      extends Effect[
        ListRulesRequest,
        AwsError,
        zio.aws.vpclattice.model.ListRulesResponse.ReadOnly
      ]
  object CreateAccessLogSubscription
      extends Effect[
        CreateAccessLogSubscriptionRequest,
        AwsError,
        zio.aws.vpclattice.model.CreateAccessLogSubscriptionResponse.ReadOnly
      ]
  object DeleteServiceNetworkServiceAssociation
      extends Effect[
        DeleteServiceNetworkServiceAssociationRequest,
        AwsError,
        zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse.ReadOnly
      ]
  object GetServiceNetworkVpcAssociation
      extends Effect[
        GetServiceNetworkVpcAssociationRequest,
        AwsError,
        zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse.ReadOnly
      ]
  object GetResourcePolicy
      extends Effect[
        GetResourcePolicyRequest,
        AwsError,
        zio.aws.vpclattice.model.GetResourcePolicyResponse.ReadOnly
      ]
  object UpdateService
      extends Effect[
        UpdateServiceRequest,
        AwsError,
        zio.aws.vpclattice.model.UpdateServiceResponse.ReadOnly
      ]
  object DeleteAuthPolicy
      extends Effect[
        DeleteAuthPolicyRequest,
        AwsError,
        zio.aws.vpclattice.model.DeleteAuthPolicyResponse.ReadOnly
      ]
  object GetTargetGroup
      extends Effect[
        GetTargetGroupRequest,
        AwsError,
        zio.aws.vpclattice.model.GetTargetGroupResponse.ReadOnly
      ]
  object UpdateServiceNetwork
      extends Effect[
        UpdateServiceNetworkRequest,
        AwsError,
        zio.aws.vpclattice.model.UpdateServiceNetworkResponse.ReadOnly
      ]
  object DeleteServiceNetwork
      extends Effect[
        DeleteServiceNetworkRequest,
        AwsError,
        zio.aws.vpclattice.model.DeleteServiceNetworkResponse.ReadOnly
      ]
  object ListListeners
      extends Stream[
        ListListenersRequest,
        AwsError,
        zio.aws.vpclattice.model.ListenerSummary.ReadOnly
      ]
  object ListListenersPaginated
      extends Effect[
        ListListenersRequest,
        AwsError,
        zio.aws.vpclattice.model.ListListenersResponse.ReadOnly
      ]
  object ListServiceNetworks
      extends Stream[
        ListServiceNetworksRequest,
        AwsError,
        zio.aws.vpclattice.model.ServiceNetworkSummary.ReadOnly
      ]
  object ListServiceNetworksPaginated
      extends Effect[
        ListServiceNetworksRequest,
        AwsError,
        zio.aws.vpclattice.model.ListServiceNetworksResponse.ReadOnly
      ]
  object PutAuthPolicy
      extends Effect[
        PutAuthPolicyRequest,
        AwsError,
        zio.aws.vpclattice.model.PutAuthPolicyResponse.ReadOnly
      ]
  object GetRule
      extends Effect[
        GetRuleRequest,
        AwsError,
        zio.aws.vpclattice.model.GetRuleResponse.ReadOnly
      ]
  object CreateServiceNetworkVpcAssociation
      extends Effect[
        CreateServiceNetworkVpcAssociationRequest,
        AwsError,
        zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse.ReadOnly
      ]
  object CreateRule
      extends Effect[
        CreateRuleRequest,
        AwsError,
        zio.aws.vpclattice.model.CreateRuleResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, VpcLattice] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, VpcLattice] { rts =>
        zio.ZIO.succeed {
          new VpcLattice {
            val api: VpcLatticeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): VpcLattice = this
            def deleteTargetGroup(request: DeleteTargetGroupRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.DeleteTargetGroupResponse.ReadOnly
            ] = proxy(DeleteTargetGroup, request)
            def updateServiceNetworkVpcAssociation(
                request: UpdateServiceNetworkVpcAssociationRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationResponse.ReadOnly
            ] = proxy(UpdateServiceNetworkVpcAssociation, request)
            def listServiceNetworkVpcAssociations(
                request: ListServiceNetworkVpcAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListServiceNetworkVpcAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listServiceNetworkVpcAssociationsPaginated(
                request: ListServiceNetworkVpcAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse.ReadOnly
            ] = proxy(ListServiceNetworkVpcAssociationsPaginated, request)
            def listTargets(request: ListTargetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.vpclattice.model.TargetSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTargets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTargetsPaginated(request: ListTargetsRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.ListTargetsResponse.ReadOnly
            ] = proxy(ListTargetsPaginated, request)
            def createService(request: CreateServiceRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.CreateServiceResponse.ReadOnly
            ] = proxy(CreateService, request)
            def getServiceNetwork(request: GetServiceNetworkRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.GetServiceNetworkResponse.ReadOnly
            ] = proxy(GetServiceNetwork, request)
            def batchUpdateRule(request: BatchUpdateRuleRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.BatchUpdateRuleResponse.ReadOnly
            ] = proxy(BatchUpdateRule, request)
            def deregisterTargets(request: DeregisterTargetsRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.DeregisterTargetsResponse.ReadOnly
            ] = proxy(DeregisterTargets, request)
            def updateAccessLogSubscription(
                request: UpdateAccessLogSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse.ReadOnly
            ] = proxy(UpdateAccessLogSubscription, request)
            def getAuthPolicy(request: GetAuthPolicyRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.GetAuthPolicyResponse.ReadOnly
            ] = proxy(GetAuthPolicy, request)
            def deleteListener(request: DeleteListenerRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.DeleteListenerResponse.ReadOnly
            ] = proxy(DeleteListener, request)
            def deleteService(request: DeleteServiceRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.DeleteServiceResponse.ReadOnly
            ] = proxy(DeleteService, request)
            def createServiceNetworkServiceAssociation(
                request: CreateServiceNetworkServiceAssociationRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse.ReadOnly
            ] = proxy(CreateServiceNetworkServiceAssociation, request)
            def listServices(request: ListServicesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.vpclattice.model.ServiceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListServices, request)
                }
                .getOrThrowFiberFailure()
            }
            def listServicesPaginated(request: ListServicesRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.ListServicesResponse.ReadOnly
            ] = proxy(ListServicesPaginated, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def listServiceNetworkServiceAssociations(
                request: ListServiceNetworkServiceAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListServiceNetworkServiceAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listServiceNetworkServiceAssociationsPaginated(
                request: ListServiceNetworkServiceAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsResponse.ReadOnly
            ] = proxy(ListServiceNetworkServiceAssociationsPaginated, request)
            def deleteServiceNetworkVpcAssociation(
                request: DeleteServiceNetworkVpcAssociationRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse.ReadOnly
            ] = proxy(DeleteServiceNetworkVpcAssociation, request)
            def deleteRule(request: DeleteRuleRequest): IO[AwsError, ReadOnly] =
              proxy(DeleteRule, request)
            def registerTargets(request: RegisterTargetsRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.RegisterTargetsResponse.ReadOnly
            ] = proxy(RegisterTargets, request)
            def listAccessLogSubscriptions(
                request: ListAccessLogSubscriptionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.vpclattice.model.AccessLogSubscriptionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAccessLogSubscriptions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAccessLogSubscriptionsPaginated(
                request: ListAccessLogSubscriptionsRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.ListAccessLogSubscriptionsResponse.ReadOnly
            ] = proxy(ListAccessLogSubscriptionsPaginated, request)
            def getAccessLogSubscription(
                request: GetAccessLogSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.GetAccessLogSubscriptionResponse.ReadOnly
            ] = proxy(GetAccessLogSubscription, request)
            def getListener(request: GetListenerRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.GetListenerResponse.ReadOnly
            ] = proxy(GetListener, request)
            def createTargetGroup(request: CreateTargetGroupRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.CreateTargetGroupResponse.ReadOnly
            ] = proxy(CreateTargetGroup, request)
            def createListener(request: CreateListenerRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.CreateListenerResponse.ReadOnly
            ] = proxy(CreateListener, request)
            def updateRule(request: UpdateRuleRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.UpdateRuleResponse.ReadOnly
            ] = proxy(UpdateRule, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def deleteAccessLogSubscription(
                request: DeleteAccessLogSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.DeleteAccessLogSubscriptionResponse.ReadOnly
            ] = proxy(DeleteAccessLogSubscription, request)
            def listTargetGroups(request: ListTargetGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTargetGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTargetGroupsPaginated(request: ListTargetGroupsRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.ListTargetGroupsResponse.ReadOnly
            ] = proxy(ListTargetGroupsPaginated, request)
            def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.DeleteResourcePolicyResponse.ReadOnly
            ] = proxy(DeleteResourcePolicy, request)
            def getService(request: GetServiceRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.GetServiceResponse.ReadOnly
            ] = proxy(GetService, request)
            def createServiceNetwork(request: CreateServiceNetworkRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.CreateServiceNetworkResponse.ReadOnly
            ] = proxy(CreateServiceNetwork, request)
            def updateTargetGroup(request: UpdateTargetGroupRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.UpdateTargetGroupResponse.ReadOnly
            ] = proxy(UpdateTargetGroup, request)
            def getServiceNetworkServiceAssociation(
                request: GetServiceNetworkServiceAssociationRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.GetServiceNetworkServiceAssociationResponse.ReadOnly
            ] = proxy(GetServiceNetworkServiceAssociation, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateListener(request: UpdateListenerRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.UpdateListenerResponse.ReadOnly
            ] = proxy(UpdateListener, request)
            def listRules(request: ListRulesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.vpclattice.model.RuleSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRules, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRulesPaginated(request: ListRulesRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.ListRulesResponse.ReadOnly
            ] = proxy(ListRulesPaginated, request)
            def createAccessLogSubscription(
                request: CreateAccessLogSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.CreateAccessLogSubscriptionResponse.ReadOnly
            ] = proxy(CreateAccessLogSubscription, request)
            def deleteServiceNetworkServiceAssociation(
                request: DeleteServiceNetworkServiceAssociationRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse.ReadOnly
            ] = proxy(DeleteServiceNetworkServiceAssociation, request)
            def getServiceNetworkVpcAssociation(
                request: GetServiceNetworkVpcAssociationRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse.ReadOnly
            ] = proxy(GetServiceNetworkVpcAssociation, request)
            def getResourcePolicy(request: GetResourcePolicyRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.GetResourcePolicyResponse.ReadOnly
            ] = proxy(GetResourcePolicy, request)
            def updateService(request: UpdateServiceRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.UpdateServiceResponse.ReadOnly
            ] = proxy(UpdateService, request)
            def deleteAuthPolicy(request: DeleteAuthPolicyRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.DeleteAuthPolicyResponse.ReadOnly
            ] = proxy(DeleteAuthPolicy, request)
            def getTargetGroup(request: GetTargetGroupRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.GetTargetGroupResponse.ReadOnly
            ] = proxy(GetTargetGroup, request)
            def updateServiceNetwork(request: UpdateServiceNetworkRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.UpdateServiceNetworkResponse.ReadOnly
            ] = proxy(UpdateServiceNetwork, request)
            def deleteServiceNetwork(request: DeleteServiceNetworkRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.DeleteServiceNetworkResponse.ReadOnly
            ] = proxy(DeleteServiceNetwork, request)
            def listListeners(request: ListListenersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.vpclattice.model.ListenerSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListListeners, request)
                }
                .getOrThrowFiberFailure()
            }
            def listListenersPaginated(request: ListListenersRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.ListListenersResponse.ReadOnly
            ] = proxy(ListListenersPaginated, request)
            def listServiceNetworks(
                request: ListServiceNetworksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.vpclattice.model.ServiceNetworkSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListServiceNetworks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listServiceNetworksPaginated(
                request: ListServiceNetworksRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.ListServiceNetworksResponse.ReadOnly
            ] = proxy(ListServiceNetworksPaginated, request)
            def putAuthPolicy(request: PutAuthPolicyRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.PutAuthPolicyResponse.ReadOnly
            ] = proxy(PutAuthPolicy, request)
            def getRule(
                request: GetRuleRequest
            ): IO[AwsError, zio.aws.vpclattice.model.GetRuleResponse.ReadOnly] =
              proxy(GetRule, request)
            def createServiceNetworkVpcAssociation(
                request: CreateServiceNetworkVpcAssociationRequest
            ): IO[
              AwsError,
              zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse.ReadOnly
            ] = proxy(CreateServiceNetworkVpcAssociation, request)
            def createRule(request: CreateRuleRequest): IO[
              AwsError,
              zio.aws.vpclattice.model.CreateRuleResponse.ReadOnly
            ] = proxy(CreateRule, request)
          }
        }
      }
    }
  }
}
