package zio.aws.vpclattice
import zio.aws.vpclattice.model.DeleteRuleResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.vpclattice.paginators.{
  ListTargetGroupsPublisher,
  ListListenersPublisher,
  ListServiceNetworksPublisher,
  ListServicesPublisher,
  ListRulesPublisher,
  ListServiceNetworkVpcAssociationsPublisher,
  ListServiceNetworkServiceAssociationsPublisher,
  ListTargetsPublisher,
  ListAccessLogSubscriptionsPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.aws.vpclattice.model.{
  CreateServiceNetworkRequest,
  ListAccessLogSubscriptionsRequest,
  GetAccessLogSubscriptionRequest,
  GetServiceNetworkRequest,
  ListListenersRequest,
  DeleteServiceRequest,
  GetListenerRequest,
  CreateServiceNetworkVpcAssociationRequest,
  RegisterTargetsRequest,
  ListRulesRequest,
  GetRuleRequest,
  ListServiceNetworkServiceAssociationsRequest,
  DeleteAccessLogSubscriptionRequest,
  PutResourcePolicyRequest,
  UpdateTargetGroupRequest,
  GetTargetGroupRequest,
  CreateServiceNetworkServiceAssociationRequest,
  ListTagsForResourceRequest,
  ListTargetsRequest,
  ListTargetGroupsRequest,
  BatchUpdateRuleRequest,
  DeregisterTargetsRequest,
  DeleteServiceNetworkServiceAssociationRequest,
  CreateRuleRequest,
  CreateServiceRequest,
  DeleteServiceNetworkRequest,
  DeleteRuleRequest,
  DeleteAuthPolicyRequest,
  UpdateListenerRequest,
  PutAuthPolicyRequest,
  CreateAccessLogSubscriptionRequest,
  ListServiceNetworksRequest,
  GetServiceNetworkServiceAssociationRequest,
  DeleteResourcePolicyRequest,
  GetServiceRequest,
  UpdateAccessLogSubscriptionRequest,
  UntagResourceRequest,
  GetAuthPolicyRequest,
  CreateTargetGroupRequest,
  ListServiceNetworkVpcAssociationsRequest,
  ListServicesRequest,
  DeleteServiceNetworkVpcAssociationRequest,
  UpdateServiceNetworkRequest,
  UpdateRuleRequest,
  DeleteListenerRequest,
  CreateListenerRequest,
  GetResourcePolicyRequest,
  DeleteTargetGroupRequest,
  GetServiceNetworkVpcAssociationRequest,
  UpdateServiceRequest,
  UpdateServiceNetworkVpcAssociationRequest,
  TagResourceRequest
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.vpclattice.model.{
  DeleteAccessLogSubscriptionResponse,
  GetListenerResponse,
  ListTargetsResponse,
  GetResourcePolicyResponse,
  GetServiceResponse,
  CreateServiceNetworkServiceAssociationResponse,
  PutResourcePolicyResponse,
  DeleteServiceNetworkResponse,
  TargetSummary,
  UpdateServiceNetworkResponse,
  UpdateServiceNetworkVpcAssociationResponse,
  ListRulesResponse,
  CreateServiceNetworkVpcAssociationResponse,
  ListListenersResponse,
  GetAuthPolicyResponse,
  GetServiceNetworkVpcAssociationResponse,
  ListenerSummary,
  UpdateRuleResponse,
  CreateTargetGroupResponse,
  ServiceSummary,
  UpdateServiceResponse,
  GetRuleResponse,
  ServiceNetworkVpcAssociationSummary,
  RuleSummary,
  DeleteServiceNetworkServiceAssociationResponse,
  UpdateAccessLogSubscriptionResponse,
  CreateServiceResponse,
  DeleteServiceResponse,
  CreateAccessLogSubscriptionResponse,
  ListTargetGroupsResponse,
  GetServiceNetworkResponse,
  ListTagsForResourceResponse,
  UpdateTargetGroupResponse,
  ServiceNetworkSummary,
  UntagResourceResponse,
  DeleteServiceNetworkVpcAssociationResponse,
  GetAccessLogSubscriptionResponse,
  ServiceNetworkServiceAssociationSummary,
  TargetGroupSummary,
  CreateServiceNetworkResponse,
  ListServiceNetworksResponse,
  GetTargetGroupResponse,
  RegisterTargetsResponse,
  DeleteListenerResponse,
  DeleteAuthPolicyResponse,
  DeleteTargetGroupResponse,
  PutAuthPolicyResponse,
  CreateListenerResponse,
  ListServiceNetworkServiceAssociationsResponse,
  CreateRuleResponse,
  ListServiceNetworkVpcAssociationsResponse,
  GetServiceNetworkServiceAssociationResponse,
  DeregisterTargetsResponse,
  DeleteResourcePolicyResponse,
  TagResourceResponse,
  BatchUpdateRuleResponse,
  ListAccessLogSubscriptionsResponse,
  DeleteRuleResponse,
  AccessLogSubscriptionSummary,
  UpdateListenerResponse,
  ListServicesResponse
}
import software.amazon.awssdk.services.vpclattice.{
  VpcLatticeAsyncClientBuilder,
  VpcLatticeAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait VpcLattice extends AspectSupport[VpcLattice] {
  val api: VpcLatticeAsyncClient
  def deleteTargetGroup(
      request: DeleteTargetGroupRequest
  ): IO[AwsError, zio.aws.vpclattice.model.DeleteTargetGroupResponse.ReadOnly]
  def updateServiceNetworkVpcAssociation(
      request: UpdateServiceNetworkVpcAssociationRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationResponse.ReadOnly
  ]
  def listServiceNetworkVpcAssociations(
      request: ListServiceNetworkVpcAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary.ReadOnly
  ]
  def listServiceNetworkVpcAssociationsPaginated(
      request: ListServiceNetworkVpcAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse.ReadOnly
  ]
  def listTargets(
      request: ListTargetsRequest
  ): ZStream[Any, AwsError, zio.aws.vpclattice.model.TargetSummary.ReadOnly]
  def listTargetsPaginated(
      request: ListTargetsRequest
  ): IO[AwsError, zio.aws.vpclattice.model.ListTargetsResponse.ReadOnly]
  def createService(
      request: CreateServiceRequest
  ): IO[AwsError, zio.aws.vpclattice.model.CreateServiceResponse.ReadOnly]
  def getServiceNetwork(
      request: GetServiceNetworkRequest
  ): IO[AwsError, zio.aws.vpclattice.model.GetServiceNetworkResponse.ReadOnly]
  def batchUpdateRule(
      request: BatchUpdateRuleRequest
  ): IO[AwsError, zio.aws.vpclattice.model.BatchUpdateRuleResponse.ReadOnly]
  def deregisterTargets(
      request: DeregisterTargetsRequest
  ): IO[AwsError, zio.aws.vpclattice.model.DeregisterTargetsResponse.ReadOnly]
  def updateAccessLogSubscription(
      request: UpdateAccessLogSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse.ReadOnly
  ]
  def getAuthPolicy(
      request: GetAuthPolicyRequest
  ): IO[AwsError, zio.aws.vpclattice.model.GetAuthPolicyResponse.ReadOnly]
  def deleteListener(
      request: DeleteListenerRequest
  ): IO[AwsError, zio.aws.vpclattice.model.DeleteListenerResponse.ReadOnly]
  def deleteService(
      request: DeleteServiceRequest
  ): IO[AwsError, zio.aws.vpclattice.model.DeleteServiceResponse.ReadOnly]
  def createServiceNetworkServiceAssociation(
      request: CreateServiceNetworkServiceAssociationRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse.ReadOnly
  ]
  def listServices(
      request: ListServicesRequest
  ): ZStream[Any, AwsError, zio.aws.vpclattice.model.ServiceSummary.ReadOnly]
  def listServicesPaginated(
      request: ListServicesRequest
  ): IO[AwsError, zio.aws.vpclattice.model.ListServicesResponse.ReadOnly]
  def putResourcePolicy(
      request: PutResourcePolicyRequest
  ): IO[AwsError, zio.aws.vpclattice.model.PutResourcePolicyResponse.ReadOnly]
  def listServiceNetworkServiceAssociations(
      request: ListServiceNetworkServiceAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary.ReadOnly
  ]
  def listServiceNetworkServiceAssociationsPaginated(
      request: ListServiceNetworkServiceAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsResponse.ReadOnly
  ]
  def deleteServiceNetworkVpcAssociation(
      request: DeleteServiceNetworkVpcAssociationRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse.ReadOnly
  ]
  def deleteRule(request: DeleteRuleRequest): IO[AwsError, ReadOnly]
  def registerTargets(
      request: RegisterTargetsRequest
  ): IO[AwsError, zio.aws.vpclattice.model.RegisterTargetsResponse.ReadOnly]
  def listAccessLogSubscriptions(
      request: ListAccessLogSubscriptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.vpclattice.model.AccessLogSubscriptionSummary.ReadOnly
  ]
  def listAccessLogSubscriptionsPaginated(
      request: ListAccessLogSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.ListAccessLogSubscriptionsResponse.ReadOnly
  ]
  def getAccessLogSubscription(request: GetAccessLogSubscriptionRequest): IO[
    AwsError,
    zio.aws.vpclattice.model.GetAccessLogSubscriptionResponse.ReadOnly
  ]
  def getListener(
      request: GetListenerRequest
  ): IO[AwsError, zio.aws.vpclattice.model.GetListenerResponse.ReadOnly]
  def createTargetGroup(
      request: CreateTargetGroupRequest
  ): IO[AwsError, zio.aws.vpclattice.model.CreateTargetGroupResponse.ReadOnly]
  def createListener(
      request: CreateListenerRequest
  ): IO[AwsError, zio.aws.vpclattice.model.CreateListenerResponse.ReadOnly]
  def updateRule(
      request: UpdateRuleRequest
  ): IO[AwsError, zio.aws.vpclattice.model.UpdateRuleResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.vpclattice.model.UntagResourceResponse.ReadOnly]
  def deleteAccessLogSubscription(
      request: DeleteAccessLogSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.DeleteAccessLogSubscriptionResponse.ReadOnly
  ]
  def listTargetGroups(request: ListTargetGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly
  ]
  def listTargetGroupsPaginated(
      request: ListTargetGroupsRequest
  ): IO[AwsError, zio.aws.vpclattice.model.ListTargetGroupsResponse.ReadOnly]
  def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
    AwsError,
    zio.aws.vpclattice.model.DeleteResourcePolicyResponse.ReadOnly
  ]
  def getService(
      request: GetServiceRequest
  ): IO[AwsError, zio.aws.vpclattice.model.GetServiceResponse.ReadOnly]
  def createServiceNetwork(request: CreateServiceNetworkRequest): IO[
    AwsError,
    zio.aws.vpclattice.model.CreateServiceNetworkResponse.ReadOnly
  ]
  def updateTargetGroup(
      request: UpdateTargetGroupRequest
  ): IO[AwsError, zio.aws.vpclattice.model.UpdateTargetGroupResponse.ReadOnly]
  def getServiceNetworkServiceAssociation(
      request: GetServiceNetworkServiceAssociationRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.GetServiceNetworkServiceAssociationResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.vpclattice.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.vpclattice.model.TagResourceResponse.ReadOnly]
  def updateListener(
      request: UpdateListenerRequest
  ): IO[AwsError, zio.aws.vpclattice.model.UpdateListenerResponse.ReadOnly]
  def listRules(
      request: ListRulesRequest
  ): ZStream[Any, AwsError, zio.aws.vpclattice.model.RuleSummary.ReadOnly]
  def listRulesPaginated(
      request: ListRulesRequest
  ): IO[AwsError, zio.aws.vpclattice.model.ListRulesResponse.ReadOnly]
  def createAccessLogSubscription(
      request: CreateAccessLogSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.CreateAccessLogSubscriptionResponse.ReadOnly
  ]
  def deleteServiceNetworkServiceAssociation(
      request: DeleteServiceNetworkServiceAssociationRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse.ReadOnly
  ]
  def getServiceNetworkVpcAssociation(
      request: GetServiceNetworkVpcAssociationRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse.ReadOnly
  ]
  def getResourcePolicy(
      request: GetResourcePolicyRequest
  ): IO[AwsError, zio.aws.vpclattice.model.GetResourcePolicyResponse.ReadOnly]
  def updateService(
      request: UpdateServiceRequest
  ): IO[AwsError, zio.aws.vpclattice.model.UpdateServiceResponse.ReadOnly]
  def deleteAuthPolicy(
      request: DeleteAuthPolicyRequest
  ): IO[AwsError, zio.aws.vpclattice.model.DeleteAuthPolicyResponse.ReadOnly]
  def getTargetGroup(
      request: GetTargetGroupRequest
  ): IO[AwsError, zio.aws.vpclattice.model.GetTargetGroupResponse.ReadOnly]
  def updateServiceNetwork(request: UpdateServiceNetworkRequest): IO[
    AwsError,
    zio.aws.vpclattice.model.UpdateServiceNetworkResponse.ReadOnly
  ]
  def deleteServiceNetwork(request: DeleteServiceNetworkRequest): IO[
    AwsError,
    zio.aws.vpclattice.model.DeleteServiceNetworkResponse.ReadOnly
  ]
  def listListeners(
      request: ListListenersRequest
  ): ZStream[Any, AwsError, zio.aws.vpclattice.model.ListenerSummary.ReadOnly]
  def listListenersPaginated(
      request: ListListenersRequest
  ): IO[AwsError, zio.aws.vpclattice.model.ListListenersResponse.ReadOnly]
  def listServiceNetworks(request: ListServiceNetworksRequest): ZStream[
    Any,
    AwsError,
    zio.aws.vpclattice.model.ServiceNetworkSummary.ReadOnly
  ]
  def listServiceNetworksPaginated(
      request: ListServiceNetworksRequest
  ): IO[AwsError, zio.aws.vpclattice.model.ListServiceNetworksResponse.ReadOnly]
  def putAuthPolicy(
      request: PutAuthPolicyRequest
  ): IO[AwsError, zio.aws.vpclattice.model.PutAuthPolicyResponse.ReadOnly]
  def getRule(
      request: GetRuleRequest
  ): IO[AwsError, zio.aws.vpclattice.model.GetRuleResponse.ReadOnly]
  def createServiceNetworkVpcAssociation(
      request: CreateServiceNetworkVpcAssociationRequest
  ): IO[
    AwsError,
    zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse.ReadOnly
  ]
  def createRule(
      request: CreateRuleRequest
  ): IO[AwsError, zio.aws.vpclattice.model.CreateRuleResponse.ReadOnly]
}
object VpcLattice {
  val live: ZLayer[AwsConfig, java.lang.Throwable, VpcLattice] = customized(
    identity
  )
  def customized(
      customization: VpcLatticeAsyncClientBuilder => VpcLatticeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, VpcLattice] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: VpcLatticeAsyncClientBuilder => VpcLatticeAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, VpcLattice] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = VpcLatticeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[VpcLatticeAsyncClient, VpcLatticeAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[VpcLatticeAsyncClient, VpcLatticeAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new VpcLatticeImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class VpcLatticeImpl[R](
      override val api: VpcLatticeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends VpcLattice
      with AwsServiceBase[R] {
    override val serviceName: String = "VpcLattice"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): VpcLatticeImpl[R1] = new VpcLatticeImpl(api, newAspect, r)
    def deleteTargetGroup(request: DeleteTargetGroupRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.DeleteTargetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupRequest,
      DeleteTargetGroupResponse
    ]("deleteTargetGroup", api.deleteTargetGroup)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.DeleteTargetGroupResponse.wrap)
      .provideEnvironment(r)
    def updateServiceNetworkVpcAssociation(
        request: UpdateServiceNetworkVpcAssociationRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest,
      UpdateServiceNetworkVpcAssociationResponse
    ](
      "updateServiceNetworkVpcAssociation",
      api.updateServiceNetworkVpcAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def listServiceNetworkVpcAssociations(
        request: ListServiceNetworkVpcAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest,
      ServiceNetworkVpcAssociationSummary,
      ListServiceNetworkVpcAssociationsPublisher
    ](
      "listServiceNetworkVpcAssociations",
      api.listServiceNetworkVpcAssociationsPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listServiceNetworkVpcAssociationsPaginated(
        request: ListServiceNetworkVpcAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest,
      ListServiceNetworkVpcAssociationsResponse
    ](
      "listServiceNetworkVpcAssociations",
      api.listServiceNetworkVpcAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def listTargets(
        request: ListTargetsRequest
    ): ZStream[Any, AwsError, zio.aws.vpclattice.model.TargetSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest,
        TargetSummary,
        ListTargetsPublisher
      ]("listTargets", api.listTargetsPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.vpclattice.model.TargetSummary.wrap(item))
        .provideEnvironment(r)
    def listTargetsPaginated(
        request: ListTargetsRequest
    ): IO[AwsError, zio.aws.vpclattice.model.ListTargetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest,
        ListTargetsResponse
      ]("listTargets", api.listTargets)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.ListTargetsResponse.wrap)
        .provideEnvironment(r)
    def createService(
        request: CreateServiceRequest
    ): IO[AwsError, zio.aws.vpclattice.model.CreateServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.CreateServiceRequest,
        CreateServiceResponse
      ]("createService", api.createService)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.CreateServiceResponse.wrap)
        .provideEnvironment(r)
    def getServiceNetwork(request: GetServiceNetworkRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.GetServiceNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkRequest,
      GetServiceNetworkResponse
    ]("getServiceNetwork", api.getServiceNetwork)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.GetServiceNetworkResponse.wrap)
      .provideEnvironment(r)
    def batchUpdateRule(
        request: BatchUpdateRuleRequest
    ): IO[AwsError, zio.aws.vpclattice.model.BatchUpdateRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleRequest,
        BatchUpdateRuleResponse
      ]("batchUpdateRule", api.batchUpdateRule)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.BatchUpdateRuleResponse.wrap)
        .provideEnvironment(r)
    def deregisterTargets(request: DeregisterTargetsRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.DeregisterTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsRequest,
      DeregisterTargetsResponse
    ]("deregisterTargets", api.deregisterTargets)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.DeregisterTargetsResponse.wrap)
      .provideEnvironment(r)
    def updateAccessLogSubscription(
        request: UpdateAccessLogSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionRequest,
      UpdateAccessLogSubscriptionResponse
    ]("updateAccessLogSubscription", api.updateAccessLogSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def getAuthPolicy(
        request: GetAuthPolicyRequest
    ): IO[AwsError, zio.aws.vpclattice.model.GetAuthPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyRequest,
        GetAuthPolicyResponse
      ]("getAuthPolicy", api.getAuthPolicy)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.GetAuthPolicyResponse.wrap)
        .provideEnvironment(r)
    def deleteListener(
        request: DeleteListenerRequest
    ): IO[AwsError, zio.aws.vpclattice.model.DeleteListenerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.DeleteListenerRequest,
        DeleteListenerResponse
      ]("deleteListener", api.deleteListener)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.DeleteListenerResponse.wrap)
        .provideEnvironment(r)
    def deleteService(
        request: DeleteServiceRequest
    ): IO[AwsError, zio.aws.vpclattice.model.DeleteServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.DeleteServiceRequest,
        DeleteServiceResponse
      ]("deleteService", api.deleteService)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.DeleteServiceResponse.wrap)
        .provideEnvironment(r)
    def createServiceNetworkServiceAssociation(
        request: CreateServiceNetworkServiceAssociationRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest,
      CreateServiceNetworkServiceAssociationResponse
    ](
      "createServiceNetworkServiceAssociation",
      api.createServiceNetworkServiceAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def listServices(request: ListServicesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ServiceSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.vpclattice.model.ListServicesRequest,
      ServiceSummary,
      ListServicesPublisher
    ]("listServices", api.listServicesPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.vpclattice.model.ServiceSummary.wrap(item))
      .provideEnvironment(r)
    def listServicesPaginated(
        request: ListServicesRequest
    ): IO[AwsError, zio.aws.vpclattice.model.ListServicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.ListServicesRequest,
        ListServicesResponse
      ]("listServices", api.listServices)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.ListServicesResponse.wrap)
        .provideEnvironment(r)
    def putResourcePolicy(request: PutResourcePolicyRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.PutResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyRequest,
      PutResourcePolicyResponse
    ]("putResourcePolicy", api.putResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.PutResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def listServiceNetworkServiceAssociations(
        request: ListServiceNetworkServiceAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest,
      ServiceNetworkServiceAssociationSummary,
      ListServiceNetworkServiceAssociationsPublisher
    ](
      "listServiceNetworkServiceAssociations",
      api.listServiceNetworkServiceAssociationsPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listServiceNetworkServiceAssociationsPaginated(
        request: ListServiceNetworkServiceAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest,
      ListServiceNetworkServiceAssociationsResponse
    ](
      "listServiceNetworkServiceAssociations",
      api.listServiceNetworkServiceAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def deleteServiceNetworkVpcAssociation(
        request: DeleteServiceNetworkVpcAssociationRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationRequest,
      DeleteServiceNetworkVpcAssociationResponse
    ](
      "deleteServiceNetworkVpcAssociation",
      api.deleteServiceNetworkVpcAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteRule(request: DeleteRuleRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.DeleteRuleRequest,
        DeleteRuleResponse
      ]("deleteRule", api.deleteRule)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.DeleteRuleResponse.wrap)
        .provideEnvironment(r)
    def registerTargets(
        request: RegisterTargetsRequest
    ): IO[AwsError, zio.aws.vpclattice.model.RegisterTargetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequest,
        RegisterTargetsResponse
      ]("registerTargets", api.registerTargets)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.RegisterTargetsResponse.wrap)
        .provideEnvironment(r)
    def listAccessLogSubscriptions(
        request: ListAccessLogSubscriptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.vpclattice.model.AccessLogSubscriptionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest,
      AccessLogSubscriptionSummary,
      ListAccessLogSubscriptionsPublisher
    ](
      "listAccessLogSubscriptions",
      api.listAccessLogSubscriptionsPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.vpclattice.model.AccessLogSubscriptionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listAccessLogSubscriptionsPaginated(
        request: ListAccessLogSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.ListAccessLogSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest,
      ListAccessLogSubscriptionsResponse
    ]("listAccessLogSubscriptions", api.listAccessLogSubscriptions)(
      request.buildAwsValue()
    ).map(zio.aws.vpclattice.model.ListAccessLogSubscriptionsResponse.wrap)
      .provideEnvironment(r)
    def getAccessLogSubscription(request: GetAccessLogSubscriptionRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.GetAccessLogSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.GetAccessLogSubscriptionRequest,
      GetAccessLogSubscriptionResponse
    ]("getAccessLogSubscription", api.getAccessLogSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.vpclattice.model.GetAccessLogSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def getListener(
        request: GetListenerRequest
    ): IO[AwsError, zio.aws.vpclattice.model.GetListenerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.GetListenerRequest,
        GetListenerResponse
      ]("getListener", api.getListener)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.GetListenerResponse.wrap)
        .provideEnvironment(r)
    def createTargetGroup(request: CreateTargetGroupRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.CreateTargetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupRequest,
      CreateTargetGroupResponse
    ]("createTargetGroup", api.createTargetGroup)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.CreateTargetGroupResponse.wrap)
      .provideEnvironment(r)
    def createListener(
        request: CreateListenerRequest
    ): IO[AwsError, zio.aws.vpclattice.model.CreateListenerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.CreateListenerRequest,
        CreateListenerResponse
      ]("createListener", api.createListener)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.CreateListenerResponse.wrap)
        .provideEnvironment(r)
    def updateRule(
        request: UpdateRuleRequest
    ): IO[AwsError, zio.aws.vpclattice.model.UpdateRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.UpdateRuleRequest,
        UpdateRuleResponse
      ]("updateRule", api.updateRule)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.UpdateRuleResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.vpclattice.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteAccessLogSubscription(
        request: DeleteAccessLogSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.DeleteAccessLogSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionRequest,
      DeleteAccessLogSubscriptionResponse
    ]("deleteAccessLogSubscription", api.deleteAccessLogSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.vpclattice.model.DeleteAccessLogSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def listTargetGroups(request: ListTargetGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest,
      TargetGroupSummary,
      ListTargetGroupsPublisher
    ]("listTargetGroups", api.listTargetGroupsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.vpclattice.model.TargetGroupSummary.wrap(item))
      .provideEnvironment(r)
    def listTargetGroupsPaginated(request: ListTargetGroupsRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.ListTargetGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest,
      ListTargetGroupsResponse
    ]("listTargetGroups", api.listTargetGroups)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.ListTargetGroupsResponse.wrap)
      .provideEnvironment(r)
    def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.DeleteResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.DeleteResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def getService(
        request: GetServiceRequest
    ): IO[AwsError, zio.aws.vpclattice.model.GetServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.GetServiceRequest,
        GetServiceResponse
      ]("getService", api.getService)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.GetServiceResponse.wrap)
        .provideEnvironment(r)
    def createServiceNetwork(request: CreateServiceNetworkRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.CreateServiceNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkRequest,
      CreateServiceNetworkResponse
    ]("createServiceNetwork", api.createServiceNetwork)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.CreateServiceNetworkResponse.wrap)
      .provideEnvironment(r)
    def updateTargetGroup(request: UpdateTargetGroupRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.UpdateTargetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupRequest,
      UpdateTargetGroupResponse
    ]("updateTargetGroup", api.updateTargetGroup)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.UpdateTargetGroupResponse.wrap)
      .provideEnvironment(r)
    def getServiceNetworkServiceAssociation(
        request: GetServiceNetworkServiceAssociationRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.GetServiceNetworkServiceAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkServiceAssociationRequest,
      GetServiceNetworkServiceAssociationResponse
    ](
      "getServiceNetworkServiceAssociation",
      api.getServiceNetworkServiceAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.vpclattice.model.GetServiceNetworkServiceAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.vpclattice.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateListener(
        request: UpdateListenerRequest
    ): IO[AwsError, zio.aws.vpclattice.model.UpdateListenerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.UpdateListenerRequest,
        UpdateListenerResponse
      ]("updateListener", api.updateListener)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.UpdateListenerResponse.wrap)
        .provideEnvironment(r)
    def listRules(
        request: ListRulesRequest
    ): ZStream[Any, AwsError, zio.aws.vpclattice.model.RuleSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.vpclattice.model.ListRulesRequest,
        RuleSummary,
        ListRulesPublisher
      ]("listRules", api.listRulesPaginator, _.items())(request.buildAwsValue())
        .map(item => zio.aws.vpclattice.model.RuleSummary.wrap(item))
        .provideEnvironment(r)
    def listRulesPaginated(
        request: ListRulesRequest
    ): IO[AwsError, zio.aws.vpclattice.model.ListRulesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.ListRulesRequest,
        ListRulesResponse
      ]("listRules", api.listRules)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.ListRulesResponse.wrap)
        .provideEnvironment(r)
    def createAccessLogSubscription(
        request: CreateAccessLogSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.CreateAccessLogSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionRequest,
      CreateAccessLogSubscriptionResponse
    ]("createAccessLogSubscription", api.createAccessLogSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.vpclattice.model.CreateAccessLogSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def deleteServiceNetworkServiceAssociation(
        request: DeleteServiceNetworkServiceAssociationRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationRequest,
      DeleteServiceNetworkServiceAssociationResponse
    ](
      "deleteServiceNetworkServiceAssociation",
      api.deleteServiceNetworkServiceAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def getServiceNetworkVpcAssociation(
        request: GetServiceNetworkVpcAssociationRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationRequest,
      GetServiceNetworkVpcAssociationResponse
    ]("getServiceNetworkVpcAssociation", api.getServiceNetworkVpcAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse.wrap)
      .provideEnvironment(r)
    def getResourcePolicy(request: GetResourcePolicyRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.GetResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyRequest,
      GetResourcePolicyResponse
    ]("getResourcePolicy", api.getResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.GetResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def updateService(
        request: UpdateServiceRequest
    ): IO[AwsError, zio.aws.vpclattice.model.UpdateServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.UpdateServiceRequest,
        UpdateServiceResponse
      ]("updateService", api.updateService)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.UpdateServiceResponse.wrap)
        .provideEnvironment(r)
    def deleteAuthPolicy(request: DeleteAuthPolicyRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.DeleteAuthPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.DeleteAuthPolicyRequest,
      DeleteAuthPolicyResponse
    ]("deleteAuthPolicy", api.deleteAuthPolicy)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.DeleteAuthPolicyResponse.wrap)
      .provideEnvironment(r)
    def getTargetGroup(
        request: GetTargetGroupRequest
    ): IO[AwsError, zio.aws.vpclattice.model.GetTargetGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.GetTargetGroupRequest,
        GetTargetGroupResponse
      ]("getTargetGroup", api.getTargetGroup)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.GetTargetGroupResponse.wrap)
        .provideEnvironment(r)
    def updateServiceNetwork(request: UpdateServiceNetworkRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.UpdateServiceNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkRequest,
      UpdateServiceNetworkResponse
    ]("updateServiceNetwork", api.updateServiceNetwork)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.UpdateServiceNetworkResponse.wrap)
      .provideEnvironment(r)
    def deleteServiceNetwork(request: DeleteServiceNetworkRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.DeleteServiceNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkRequest,
      DeleteServiceNetworkResponse
    ]("deleteServiceNetwork", api.deleteServiceNetwork)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.DeleteServiceNetworkResponse.wrap)
      .provideEnvironment(r)
    def listListeners(request: ListListenersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ListenerSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.vpclattice.model.ListListenersRequest,
      ListenerSummary,
      ListListenersPublisher
    ]("listListeners", api.listListenersPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.vpclattice.model.ListenerSummary.wrap(item))
      .provideEnvironment(r)
    def listListenersPaginated(
        request: ListListenersRequest
    ): IO[AwsError, zio.aws.vpclattice.model.ListListenersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.ListListenersRequest,
        ListListenersResponse
      ]("listListeners", api.listListeners)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.ListListenersResponse.wrap)
        .provideEnvironment(r)
    def listServiceNetworks(request: ListServiceNetworksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.vpclattice.model.ServiceNetworkSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest,
      ServiceNetworkSummary,
      ListServiceNetworksPublisher
    ]("listServiceNetworks", api.listServiceNetworksPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.vpclattice.model.ServiceNetworkSummary.wrap(item))
      .provideEnvironment(r)
    def listServiceNetworksPaginated(request: ListServiceNetworksRequest): IO[
      AwsError,
      zio.aws.vpclattice.model.ListServiceNetworksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest,
      ListServiceNetworksResponse
    ]("listServiceNetworks", api.listServiceNetworks)(request.buildAwsValue())
      .map(zio.aws.vpclattice.model.ListServiceNetworksResponse.wrap)
      .provideEnvironment(r)
    def putAuthPolicy(
        request: PutAuthPolicyRequest
    ): IO[AwsError, zio.aws.vpclattice.model.PutAuthPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyRequest,
        PutAuthPolicyResponse
      ]("putAuthPolicy", api.putAuthPolicy)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.PutAuthPolicyResponse.wrap)
        .provideEnvironment(r)
    def getRule(
        request: GetRuleRequest
    ): IO[AwsError, zio.aws.vpclattice.model.GetRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.GetRuleRequest,
        GetRuleResponse
      ]("getRule", api.getRule)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.GetRuleResponse.wrap)
        .provideEnvironment(r)
    def createServiceNetworkVpcAssociation(
        request: CreateServiceNetworkVpcAssociationRequest
    ): IO[
      AwsError,
      zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest,
      CreateServiceNetworkVpcAssociationResponse
    ](
      "createServiceNetworkVpcAssociation",
      api.createServiceNetworkVpcAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def createRule(
        request: CreateRuleRequest
    ): IO[AwsError, zio.aws.vpclattice.model.CreateRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.vpclattice.model.CreateRuleRequest,
        CreateRuleResponse
      ]("createRule", api.createRule)(request.buildAwsValue())
        .map(zio.aws.vpclattice.model.CreateRuleResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteTargetGroup(request: DeleteTargetGroupRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.DeleteTargetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTargetGroup(request))
  def updateServiceNetworkVpcAssociation(
      request: UpdateServiceNetworkVpcAssociationRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.UpdateServiceNetworkVpcAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServiceNetworkVpcAssociation(request))
  def listServiceNetworkVpcAssociations(
      request: ListServiceNetworkVpcAssociationsRequest
  ): ZStream[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ServiceNetworkVpcAssociationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listServiceNetworkVpcAssociations(request))
  def listServiceNetworkVpcAssociationsPaginated(
      request: ListServiceNetworkVpcAssociationsRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListServiceNetworkVpcAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceNetworkVpcAssociationsPaginated(request))
  def listTargets(request: ListTargetsRequest): ZStream[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.TargetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTargets(request))
  def listTargetsPaginated(request: ListTargetsRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTargetsPaginated(request))
  def createService(request: CreateServiceRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.CreateServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createService(request))
  def getServiceNetwork(request: GetServiceNetworkRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.GetServiceNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceNetwork(request))
  def batchUpdateRule(request: BatchUpdateRuleRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.BatchUpdateRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateRule(request))
  def deregisterTargets(request: DeregisterTargetsRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.DeregisterTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterTargets(request))
  def updateAccessLogSubscription(
      request: UpdateAccessLogSubscriptionRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.UpdateAccessLogSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccessLogSubscription(request))
  def getAuthPolicy(request: GetAuthPolicyRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.GetAuthPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAuthPolicy(request))
  def deleteListener(request: DeleteListenerRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.DeleteListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteListener(request))
  def deleteService(request: DeleteServiceRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.DeleteServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteService(request))
  def createServiceNetworkServiceAssociation(
      request: CreateServiceNetworkServiceAssociationRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.CreateServiceNetworkServiceAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServiceNetworkServiceAssociation(request))
  def listServices(request: ListServicesRequest): ZStream[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ServiceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listServices(request))
  def listServicesPaginated(request: ListServicesRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServicesPaginated(request))
  def putResourcePolicy(request: PutResourcePolicyRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.PutResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePolicy(request))
  def listServiceNetworkServiceAssociations(
      request: ListServiceNetworkServiceAssociationsRequest
  ): ZStream[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ServiceNetworkServiceAssociationSummary.ReadOnly
  ] =
    ZStream.serviceWithStream(_.listServiceNetworkServiceAssociations(request))
  def listServiceNetworkServiceAssociationsPaginated(
      request: ListServiceNetworkServiceAssociationsRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListServiceNetworkServiceAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listServiceNetworkServiceAssociationsPaginated(request)
  )
  def deleteServiceNetworkVpcAssociation(
      request: DeleteServiceNetworkVpcAssociationRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteServiceNetworkVpcAssociation(request))
  def deleteRule(
      request: DeleteRuleRequest
  ): ZIO[zio.aws.vpclattice.VpcLattice, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteRule(request))
  def registerTargets(request: RegisterTargetsRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.RegisterTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerTargets(request))
  def listAccessLogSubscriptions(
      request: ListAccessLogSubscriptionsRequest
  ): ZStream[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.AccessLogSubscriptionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccessLogSubscriptions(request))
  def listAccessLogSubscriptionsPaginated(
      request: ListAccessLogSubscriptionsRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListAccessLogSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessLogSubscriptionsPaginated(request))
  def getAccessLogSubscription(request: GetAccessLogSubscriptionRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.GetAccessLogSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessLogSubscription(request))
  def getListener(request: GetListenerRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.GetListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getListener(request))
  def createTargetGroup(request: CreateTargetGroupRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.CreateTargetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTargetGroup(request))
  def createListener(request: CreateListenerRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.CreateListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createListener(request))
  def updateRule(request: UpdateRuleRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.UpdateRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRule(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteAccessLogSubscription(
      request: DeleteAccessLogSubscriptionRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.DeleteAccessLogSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAccessLogSubscription(request))
  def listTargetGroups(request: ListTargetGroupsRequest): ZStream[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.TargetGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTargetGroups(request))
  def listTargetGroupsPaginated(request: ListTargetGroupsRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListTargetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTargetGroupsPaginated(request))
  def deleteResourcePolicy(request: DeleteResourcePolicyRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.DeleteResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def getService(request: GetServiceRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.GetServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getService(request))
  def createServiceNetwork(request: CreateServiceNetworkRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.CreateServiceNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServiceNetwork(request))
  def updateTargetGroup(request: UpdateTargetGroupRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.UpdateTargetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTargetGroup(request))
  def getServiceNetworkServiceAssociation(
      request: GetServiceNetworkServiceAssociationRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.GetServiceNetworkServiceAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceNetworkServiceAssociation(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateListener(request: UpdateListenerRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.UpdateListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateListener(request))
  def listRules(request: ListRulesRequest): ZStream[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.RuleSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRules(request))
  def listRulesPaginated(request: ListRulesRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRulesPaginated(request))
  def createAccessLogSubscription(
      request: CreateAccessLogSubscriptionRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.CreateAccessLogSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccessLogSubscription(request))
  def deleteServiceNetworkServiceAssociation(
      request: DeleteServiceNetworkServiceAssociationRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteServiceNetworkServiceAssociation(request))
  def getServiceNetworkVpcAssociation(
      request: GetServiceNetworkVpcAssociationRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.GetServiceNetworkVpcAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceNetworkVpcAssociation(request))
  def getResourcePolicy(request: GetResourcePolicyRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.GetResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcePolicy(request))
  def updateService(request: UpdateServiceRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.UpdateServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateService(request))
  def deleteAuthPolicy(request: DeleteAuthPolicyRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.DeleteAuthPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAuthPolicy(request))
  def getTargetGroup(request: GetTargetGroupRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.GetTargetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTargetGroup(request))
  def updateServiceNetwork(request: UpdateServiceNetworkRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.UpdateServiceNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServiceNetwork(request))
  def deleteServiceNetwork(request: DeleteServiceNetworkRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.DeleteServiceNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteServiceNetwork(request))
  def listListeners(request: ListListenersRequest): ZStream[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListenerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listListeners(request))
  def listListenersPaginated(request: ListListenersRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListListenersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listListenersPaginated(request))
  def listServiceNetworks(request: ListServiceNetworksRequest): ZStream[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ServiceNetworkSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listServiceNetworks(request))
  def listServiceNetworksPaginated(request: ListServiceNetworksRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.ListServiceNetworksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceNetworksPaginated(request))
  def putAuthPolicy(request: PutAuthPolicyRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.PutAuthPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAuthPolicy(request))
  def getRule(request: GetRuleRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.GetRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRule(request))
  def createServiceNetworkVpcAssociation(
      request: CreateServiceNetworkVpcAssociationRequest
  ): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.CreateServiceNetworkVpcAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServiceNetworkVpcAssociation(request))
  def createRule(request: CreateRuleRequest): ZIO[
    zio.aws.vpclattice.VpcLattice,
    AwsError,
    zio.aws.vpclattice.model.CreateRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRule(request))
}
