package zio.aws.transcribestreaming.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.transcribestreaming.model.primitives.{
  VocabularyFilterNames,
  NumberOfChannels,
  MediaSampleRateHertz,
  LanguageOptions,
  VocabularyNames,
  VocabularyName,
  VocabularyFilterName,
  ModelName,
  SessionId,
  PiiEntityTypes
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StartStreamTranscriptionRequest(
    languageCode: Optional[zio.aws.transcribestreaming.model.LanguageCode] =
      Optional.Absent,
    mediaSampleRateHertz: MediaSampleRateHertz,
    mediaEncoding: zio.aws.transcribestreaming.model.MediaEncoding,
    vocabularyName: Optional[VocabularyName] = Optional.Absent,
    sessionId: Optional[SessionId] = Optional.Absent,
    vocabularyFilterName: Optional[VocabularyFilterName] = Optional.Absent,
    vocabularyFilterMethod: Optional[
      zio.aws.transcribestreaming.model.VocabularyFilterMethod
    ] = Optional.Absent,
    showSpeakerLabel: Optional[Boolean] = Optional.Absent,
    enableChannelIdentification: Optional[Boolean] = Optional.Absent,
    numberOfChannels: Optional[NumberOfChannels] = Optional.Absent,
    enablePartialResultsStabilization: Optional[Boolean] = Optional.Absent,
    partialResultsStability: Optional[
      zio.aws.transcribestreaming.model.PartialResultsStability
    ] = Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.transcribestreaming.model.ContentIdentificationType
    ] = Optional.Absent,
    contentRedactionType: Optional[
      zio.aws.transcribestreaming.model.ContentRedactionType
    ] = Optional.Absent,
    piiEntityTypes: Optional[PiiEntityTypes] = Optional.Absent,
    languageModelName: Optional[ModelName] = Optional.Absent,
    identifyLanguage: Optional[Boolean] = Optional.Absent,
    languageOptions: Optional[LanguageOptions] = Optional.Absent,
    preferredLanguage: Optional[
      zio.aws.transcribestreaming.model.LanguageCode
    ] = Optional.Absent,
    vocabularyNames: Optional[VocabularyNames] = Optional.Absent,
    vocabularyFilterNames: Optional[VocabularyFilterNames] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest = {
    import StartStreamTranscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest
      .builder()
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .mediaSampleRateHertz(
        MediaSampleRateHertz.unwrap(mediaSampleRateHertz): Integer
      )
      .mediaEncoding(mediaEncoding.unwrap)
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(vocabularyFilterMethod.map(value => value.unwrap))(
        _.vocabularyFilterMethod
      )
      .optionallyWith(showSpeakerLabel.map(value => value: java.lang.Boolean))(
        _.showSpeakerLabel
      )
      .optionallyWith(
        enableChannelIdentification.map(value => value: java.lang.Boolean)
      )(_.enableChannelIdentification)
      .optionallyWith(
        numberOfChannels.map(value => NumberOfChannels.unwrap(value): Integer)
      )(_.numberOfChannels)
      .optionallyWith(
        enablePartialResultsStabilization.map(value => value: java.lang.Boolean)
      )(_.enablePartialResultsStabilization)
      .optionallyWith(partialResultsStability.map(value => value.unwrap))(
        _.partialResultsStability
      )
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(contentRedactionType.map(value => value.unwrap))(
        _.contentRedactionType
      )
      .optionallyWith(
        piiEntityTypes.map(value =>
          PiiEntityTypes.unwrap(value): java.lang.String
        )
      )(_.piiEntityTypes)
      .optionallyWith(
        languageModelName.map(value =>
          ModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        languageOptions.map(value =>
          LanguageOptions.unwrap(value): java.lang.String
        )
      )(_.languageOptions)
      .optionallyWith(preferredLanguage.map(value => value.unwrap))(
        _.preferredLanguage
      )
      .optionallyWith(
        vocabularyNames.map(value =>
          VocabularyNames.unwrap(value): java.lang.String
        )
      )(_.vocabularyNames)
      .optionallyWith(
        vocabularyFilterNames.map(value =>
          VocabularyFilterNames.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterNames)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest.ReadOnly =
    zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest
      .wrap(buildAwsValue())
}
object StartStreamTranscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest =
      zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest(
        languageCode.map(value => value),
        mediaSampleRateHertz,
        mediaEncoding,
        vocabularyName.map(value => value),
        sessionId.map(value => value),
        vocabularyFilterName.map(value => value),
        vocabularyFilterMethod.map(value => value),
        showSpeakerLabel.map(value => value),
        enableChannelIdentification.map(value => value),
        numberOfChannels.map(value => value),
        enablePartialResultsStabilization.map(value => value),
        partialResultsStability.map(value => value),
        contentIdentificationType.map(value => value),
        contentRedactionType.map(value => value),
        piiEntityTypes.map(value => value),
        languageModelName.map(value => value),
        identifyLanguage.map(value => value),
        languageOptions.map(value => value),
        preferredLanguage.map(value => value),
        vocabularyNames.map(value => value),
        vocabularyFilterNames.map(value => value)
      )
    def languageCode: Optional[zio.aws.transcribestreaming.model.LanguageCode]
    def mediaSampleRateHertz: MediaSampleRateHertz
    def mediaEncoding: zio.aws.transcribestreaming.model.MediaEncoding
    def vocabularyName: Optional[VocabularyName]
    def sessionId: Optional[SessionId]
    def vocabularyFilterName: Optional[VocabularyFilterName]
    def vocabularyFilterMethod
        : Optional[zio.aws.transcribestreaming.model.VocabularyFilterMethod]
    def showSpeakerLabel: Optional[Boolean]
    def enableChannelIdentification: Optional[Boolean]
    def numberOfChannels: Optional[NumberOfChannels]
    def enablePartialResultsStabilization: Optional[Boolean]
    def partialResultsStability
        : Optional[zio.aws.transcribestreaming.model.PartialResultsStability]
    def contentIdentificationType
        : Optional[zio.aws.transcribestreaming.model.ContentIdentificationType]
    def contentRedactionType
        : Optional[zio.aws.transcribestreaming.model.ContentRedactionType]
    def piiEntityTypes: Optional[PiiEntityTypes]
    def languageModelName: Optional[ModelName]
    def identifyLanguage: Optional[Boolean]
    def languageOptions: Optional[LanguageOptions]
    def preferredLanguage
        : Optional[zio.aws.transcribestreaming.model.LanguageCode]
    def vocabularyNames: Optional[VocabularyNames]
    def vocabularyFilterNames: Optional[VocabularyFilterNames]
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getMediaSampleRateHertz: ZIO[Any, Nothing, MediaSampleRateHertz] =
      ZIO.succeed(mediaSampleRateHertz)
    def getMediaEncoding
        : ZIO[Any, Nothing, zio.aws.transcribestreaming.model.MediaEncoding] =
      ZIO.succeed(mediaEncoding)
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getVocabularyFilterMethod: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.VocabularyFilterMethod
    ] = AwsError.unwrapOptionField(
      "vocabularyFilterMethod",
      vocabularyFilterMethod
    )
    def getShowSpeakerLabel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showSpeakerLabel", showSpeakerLabel)
    def getEnableChannelIdentification: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableChannelIdentification",
        enableChannelIdentification
      )
    def getNumberOfChannels: ZIO[Any, AwsError, NumberOfChannels] =
      AwsError.unwrapOptionField("numberOfChannels", numberOfChannels)
    def getEnablePartialResultsStabilization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enablePartialResultsStabilization",
        enablePartialResultsStabilization
      )
    def getPartialResultsStability: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.PartialResultsStability
    ] = AwsError.unwrapOptionField(
      "partialResultsStability",
      partialResultsStability
    )
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.ContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getContentRedactionType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.ContentRedactionType
    ] = AwsError.unwrapOptionField("contentRedactionType", contentRedactionType)
    def getPiiEntityTypes: ZIO[Any, AwsError, PiiEntityTypes] =
      AwsError.unwrapOptionField("piiEntityTypes", piiEntityTypes)
    def getLanguageModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getLanguageOptions: ZIO[Any, AwsError, LanguageOptions] =
      AwsError.unwrapOptionField("languageOptions", languageOptions)
    def getPreferredLanguage
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.LanguageCode] =
      AwsError.unwrapOptionField("preferredLanguage", preferredLanguage)
    def getVocabularyNames: ZIO[Any, AwsError, VocabularyNames] =
      AwsError.unwrapOptionField("vocabularyNames", vocabularyNames)
    def getVocabularyFilterNames: ZIO[Any, AwsError, VocabularyFilterNames] =
      AwsError.unwrapOptionField("vocabularyFilterNames", vocabularyFilterNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest
  ) extends zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest.ReadOnly {
    override val languageCode
        : Optional[zio.aws.transcribestreaming.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value =>
          zio.aws.transcribestreaming.model.LanguageCode.wrap(value)
        )
    override val mediaSampleRateHertz: MediaSampleRateHertz =
      zio.aws.transcribestreaming.model.primitives
        .MediaSampleRateHertz(impl.mediaSampleRateHertz())
    override val mediaEncoding
        : zio.aws.transcribestreaming.model.MediaEncoding =
      zio.aws.transcribestreaming.model.MediaEncoding.wrap(impl.mediaEncoding())
    override val vocabularyName: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyName())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives.VocabularyName(value)
        )
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.SessionId(value)
      )
    override val vocabularyFilterName: Optional[VocabularyFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterName())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives
            .VocabularyFilterName(value)
        )
    override val vocabularyFilterMethod
        : Optional[zio.aws.transcribestreaming.model.VocabularyFilterMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterMethod())
        .map(value =>
          zio.aws.transcribestreaming.model.VocabularyFilterMethod.wrap(value)
        )
    override val showSpeakerLabel: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.showSpeakerLabel())
      .map(value => value: Boolean)
    override val enableChannelIdentification: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableChannelIdentification())
        .map(value => value: Boolean)
    override val numberOfChannels: Optional[NumberOfChannels] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfChannels())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives.NumberOfChannels(value)
        )
    override val enablePartialResultsStabilization: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePartialResultsStabilization())
        .map(value => value: Boolean)
    override val partialResultsStability
        : Optional[zio.aws.transcribestreaming.model.PartialResultsStability] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partialResultsStability())
        .map(value =>
          zio.aws.transcribestreaming.model.PartialResultsStability.wrap(value)
        )
    override val contentIdentificationType: Optional[
      zio.aws.transcribestreaming.model.ContentIdentificationType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentIdentificationType())
      .map(value =>
        zio.aws.transcribestreaming.model.ContentIdentificationType.wrap(value)
      )
    override val contentRedactionType
        : Optional[zio.aws.transcribestreaming.model.ContentRedactionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRedactionType())
        .map(value =>
          zio.aws.transcribestreaming.model.ContentRedactionType.wrap(value)
        )
    override val piiEntityTypes: Optional[PiiEntityTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.piiEntityTypes())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives.PiiEntityTypes(value)
        )
    override val languageModelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.languageModelName())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.ModelName(value)
      )
    override val identifyLanguage: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.identifyLanguage())
      .map(value => value: Boolean)
    override val languageOptions: Optional[LanguageOptions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageOptions())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives.LanguageOptions(value)
        )
    override val preferredLanguage
        : Optional[zio.aws.transcribestreaming.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredLanguage())
        .map(value =>
          zio.aws.transcribestreaming.model.LanguageCode.wrap(value)
        )
    override val vocabularyNames: Optional[VocabularyNames] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyNames())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives.VocabularyNames(value)
        )
    override val vocabularyFilterNames: Optional[VocabularyFilterNames] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterNames())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives
            .VocabularyFilterNames(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest
  ): zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
