package zio.aws.transcribestreaming.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.transcribestreaming.model.primitives.{
  NumberOfChannels,
  SessionId,
  VocabularyName,
  MediaSampleRateHertz
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StartMedicalStreamTranscriptionRequest(
    languageCode: zio.aws.transcribestreaming.model.LanguageCode,
    mediaSampleRateHertz: MediaSampleRateHertz,
    mediaEncoding: zio.aws.transcribestreaming.model.MediaEncoding,
    vocabularyName: Optional[VocabularyName] = Optional.Absent,
    specialty: zio.aws.transcribestreaming.model.Specialty,
    `type`: zio.aws.transcribestreaming.model.Type,
    showSpeakerLabel: Optional[Boolean] = Optional.Absent,
    sessionId: Optional[SessionId] = Optional.Absent,
    enableChannelIdentification: Optional[Boolean] = Optional.Absent,
    numberOfChannels: Optional[NumberOfChannels] = Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.transcribestreaming.model.MedicalContentIdentificationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.StartMedicalStreamTranscriptionRequest = {
    import StartMedicalStreamTranscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.StartMedicalStreamTranscriptionRequest
      .builder()
      .languageCode(languageCode.unwrap)
      .mediaSampleRateHertz(
        MediaSampleRateHertz.unwrap(mediaSampleRateHertz): Integer
      )
      .mediaEncoding(mediaEncoding.unwrap)
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .specialty(specialty.unwrap)
      .`type`(`type`.unwrap)
      .optionallyWith(showSpeakerLabel.map(value => value: java.lang.Boolean))(
        _.showSpeakerLabel
      )
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        enableChannelIdentification.map(value => value: java.lang.Boolean)
      )(_.enableChannelIdentification)
      .optionallyWith(
        numberOfChannels.map(value => NumberOfChannels.unwrap(value): Integer)
      )(_.numberOfChannels)
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribestreaming.model.StartMedicalStreamTranscriptionRequest.ReadOnly =
    zio.aws.transcribestreaming.model.StartMedicalStreamTranscriptionRequest
      .wrap(buildAwsValue())
}
object StartMedicalStreamTranscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.StartMedicalStreamTranscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribestreaming.model.StartMedicalStreamTranscriptionRequest =
      zio.aws.transcribestreaming.model.StartMedicalStreamTranscriptionRequest(
        languageCode,
        mediaSampleRateHertz,
        mediaEncoding,
        vocabularyName.map(value => value),
        specialty,
        `type`,
        showSpeakerLabel.map(value => value),
        sessionId.map(value => value),
        enableChannelIdentification.map(value => value),
        numberOfChannels.map(value => value),
        contentIdentificationType.map(value => value)
      )
    def languageCode: zio.aws.transcribestreaming.model.LanguageCode
    def mediaSampleRateHertz: MediaSampleRateHertz
    def mediaEncoding: zio.aws.transcribestreaming.model.MediaEncoding
    def vocabularyName: Optional[VocabularyName]
    def specialty: zio.aws.transcribestreaming.model.Specialty
    def `type`: zio.aws.transcribestreaming.model.Type
    def showSpeakerLabel: Optional[Boolean]
    def sessionId: Optional[SessionId]
    def enableChannelIdentification: Optional[Boolean]
    def numberOfChannels: Optional[NumberOfChannels]
    def contentIdentificationType: Optional[
      zio.aws.transcribestreaming.model.MedicalContentIdentificationType
    ]
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.transcribestreaming.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getMediaSampleRateHertz: ZIO[Any, Nothing, MediaSampleRateHertz] =
      ZIO.succeed(mediaSampleRateHertz)
    def getMediaEncoding
        : ZIO[Any, Nothing, zio.aws.transcribestreaming.model.MediaEncoding] =
      ZIO.succeed(mediaEncoding)
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getSpecialty
        : ZIO[Any, Nothing, zio.aws.transcribestreaming.model.Specialty] =
      ZIO.succeed(specialty)
    def getType: ZIO[Any, Nothing, zio.aws.transcribestreaming.model.Type] =
      ZIO.succeed(`type`)
    def getShowSpeakerLabel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showSpeakerLabel", showSpeakerLabel)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getEnableChannelIdentification: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableChannelIdentification",
        enableChannelIdentification
      )
    def getNumberOfChannels: ZIO[Any, AwsError, NumberOfChannels] =
      AwsError.unwrapOptionField("numberOfChannels", numberOfChannels)
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.MedicalContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.StartMedicalStreamTranscriptionRequest
  ) extends zio.aws.transcribestreaming.model.StartMedicalStreamTranscriptionRequest.ReadOnly {
    override val languageCode: zio.aws.transcribestreaming.model.LanguageCode =
      zio.aws.transcribestreaming.model.LanguageCode.wrap(impl.languageCode())
    override val mediaSampleRateHertz: MediaSampleRateHertz =
      zio.aws.transcribestreaming.model.primitives
        .MediaSampleRateHertz(impl.mediaSampleRateHertz())
    override val mediaEncoding
        : zio.aws.transcribestreaming.model.MediaEncoding =
      zio.aws.transcribestreaming.model.MediaEncoding.wrap(impl.mediaEncoding())
    override val vocabularyName: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyName())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives.VocabularyName(value)
        )
    override val specialty: zio.aws.transcribestreaming.model.Specialty =
      zio.aws.transcribestreaming.model.Specialty.wrap(impl.specialty())
    override val `type`: zio.aws.transcribestreaming.model.Type =
      zio.aws.transcribestreaming.model.Type.wrap(impl.`type`())
    override val showSpeakerLabel: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.showSpeakerLabel())
      .map(value => value: Boolean)
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.SessionId(value)
      )
    override val enableChannelIdentification: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableChannelIdentification())
        .map(value => value: Boolean)
    override val numberOfChannels: Optional[NumberOfChannels] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfChannels())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives.NumberOfChannels(value)
        )
    override val contentIdentificationType: Optional[
      zio.aws.transcribestreaming.model.MedicalContentIdentificationType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentIdentificationType())
      .map(value =>
        zio.aws.transcribestreaming.model.MedicalContentIdentificationType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.StartMedicalStreamTranscriptionRequest
  ): zio.aws.transcribestreaming.model.StartMedicalStreamTranscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
