package zio.aws.transcribestreaming.model
import scala.jdk.CollectionConverters.*
sealed trait Specialty {
  def unwrap
      : software.amazon.awssdk.services.transcribestreaming.model.Specialty
}
object Specialty {
  def wrap(
      value: software.amazon.awssdk.services.transcribestreaming.model.Specialty
  ): zio.aws.transcribestreaming.model.Specialty = value match {
    case software.amazon.awssdk.services.transcribestreaming.model.Specialty.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Specialty.PRIMARYCARE =>
      val r = PRIMARYCARE
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Specialty.CARDIOLOGY =>
      val r = CARDIOLOGY
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Specialty.NEUROLOGY =>
      val r = NEUROLOGY
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Specialty.ONCOLOGY =>
      val r = ONCOLOGY
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Specialty.RADIOLOGY =>
      val r = RADIOLOGY
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Specialty.UROLOGY =>
      val r = UROLOGY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribestreaming.model.Specialty {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Specialty =
      software.amazon.awssdk.services.transcribestreaming.model.Specialty.UNKNOWN_TO_SDK_VERSION
  }
  case object PRIMARYCARE extends zio.aws.transcribestreaming.model.Specialty {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Specialty =
      software.amazon.awssdk.services.transcribestreaming.model.Specialty.PRIMARYCARE
  }
  case object CARDIOLOGY extends zio.aws.transcribestreaming.model.Specialty {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Specialty =
      software.amazon.awssdk.services.transcribestreaming.model.Specialty.CARDIOLOGY
  }
  case object NEUROLOGY extends zio.aws.transcribestreaming.model.Specialty {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Specialty =
      software.amazon.awssdk.services.transcribestreaming.model.Specialty.NEUROLOGY
  }
  case object ONCOLOGY extends zio.aws.transcribestreaming.model.Specialty {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Specialty =
      software.amazon.awssdk.services.transcribestreaming.model.Specialty.ONCOLOGY
  }
  case object RADIOLOGY extends zio.aws.transcribestreaming.model.Specialty {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Specialty =
      software.amazon.awssdk.services.transcribestreaming.model.Specialty.RADIOLOGY
  }
  case object UROLOGY extends zio.aws.transcribestreaming.model.Specialty {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Specialty =
      software.amazon.awssdk.services.transcribestreaming.model.Specialty.UROLOGY
  }
}
