package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Result(
    resultId: Optional[String] = Optional.Absent,
    startTime: Optional[Double] = Optional.Absent,
    endTime: Optional[Double] = Optional.Absent,
    isPartial: Optional[Boolean] = Optional.Absent,
    alternatives: Optional[
      Iterable[zio.aws.transcribestreaming.model.Alternative]
    ] = Optional.Absent,
    channelId: Optional[String] = Optional.Absent,
    languageCode: Optional[zio.aws.transcribestreaming.model.LanguageCode] =
      Optional.Absent,
    languageIdentification: Optional[
      Iterable[zio.aws.transcribestreaming.model.LanguageWithScore]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.Result = {
    import Result.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.Result
      .builder()
      .optionallyWith(resultId.map(value => value: java.lang.String))(
        _.resultId
      )
      .optionallyWith(startTime.map(value => value: java.lang.Double))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => value: java.lang.Double))(_.endTime)
      .optionallyWith(isPartial.map(value => value: java.lang.Boolean))(
        _.isPartial
      )
      .optionallyWith(
        alternatives.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternatives)
      .optionallyWith(channelId.map(value => value: java.lang.String))(
        _.channelId
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        languageIdentification.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.languageIdentification)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.Result.ReadOnly =
    zio.aws.transcribestreaming.model.Result.wrap(buildAwsValue())
}
object Result {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.Result
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.Result =
      zio.aws.transcribestreaming.model.Result(
        resultId.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        isPartial.map(value => value),
        alternatives.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        channelId.map(value => value),
        languageCode.map(value => value),
        languageIdentification.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resultId: Optional[String]
    def startTime: Optional[Double]
    def endTime: Optional[Double]
    def isPartial: Optional[Boolean]
    def alternatives
        : Optional[List[zio.aws.transcribestreaming.model.Alternative.ReadOnly]]
    def channelId: Optional[String]
    def languageCode: Optional[zio.aws.transcribestreaming.model.LanguageCode]
    def languageIdentification: Optional[
      List[zio.aws.transcribestreaming.model.LanguageWithScore.ReadOnly]
    ]
    def getResultId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultId", resultId)
    def getStartTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getIsPartial: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPartial", isPartial)
    def getAlternatives: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.Alternative.ReadOnly
    ]] = AwsError.unwrapOptionField("alternatives", alternatives)
    def getChannelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLanguageIdentification: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.LanguageWithScore.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "languageIdentification",
      languageIdentification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Result
  ) extends zio.aws.transcribestreaming.model.Result.ReadOnly {
    override val resultId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resultId())
      .map(value => value: String)
    override val startTime: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: Double)
    override val endTime: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: Double)
    override val isPartial: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPartial())
      .map(value => value: Boolean)
    override val alternatives: Optional[
      List[zio.aws.transcribestreaming.model.Alternative.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.alternatives())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.Alternative.wrap(item)
        }.toList
      )
    override val channelId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.channelId())
      .map(value => value: String)
    override val languageCode
        : Optional[zio.aws.transcribestreaming.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value =>
          zio.aws.transcribestreaming.model.LanguageCode.wrap(value)
        )
    override val languageIdentification: Optional[
      List[zio.aws.transcribestreaming.model.LanguageWithScore.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.languageIdentification())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.LanguageWithScore.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Result
  ): zio.aws.transcribestreaming.model.Result.ReadOnly = new Wrapper(impl)
}
