package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MedicalTranscript(
    results: Optional[
      Iterable[zio.aws.transcribestreaming.model.MedicalResult]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.MedicalTranscript = {
    import MedicalTranscript.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.MedicalTranscript
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.MedicalTranscript.ReadOnly =
    zio.aws.transcribestreaming.model.MedicalTranscript.wrap(buildAwsValue())
}
object MedicalTranscript {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.MedicalTranscript
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.MedicalTranscript =
      zio.aws.transcribestreaming.model.MedicalTranscript(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def results: Optional[
      List[zio.aws.transcribestreaming.model.MedicalResult.ReadOnly]
    ]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.MedicalResult.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalTranscript
  ) extends zio.aws.transcribestreaming.model.MedicalTranscript.ReadOnly {
    override val results: Optional[
      List[zio.aws.transcribestreaming.model.MedicalResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.results())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.MedicalResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalTranscript
  ): zio.aws.transcribestreaming.model.MedicalTranscript.ReadOnly = new Wrapper(
    impl
  )
}
