package zio.aws.transcribestreaming.model
import zio.aws.transcribestreaming.model.primitives.Confidence
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MedicalEntity(
    startTime: Optional[Double] = Optional.Absent,
    endTime: Optional[Double] = Optional.Absent,
    category: Optional[String] = Optional.Absent,
    content: Optional[String] = Optional.Absent,
    confidence: Optional[Confidence] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.MedicalEntity = {
    import MedicalEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.MedicalEntity
      .builder()
      .optionallyWith(startTime.map(value => value: java.lang.Double))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => value: java.lang.Double))(_.endTime)
      .optionallyWith(category.map(value => value: java.lang.String))(
        _.category
      )
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(
        confidence.map(value => Confidence.unwrap(value): java.lang.Double)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.MedicalEntity.ReadOnly =
    zio.aws.transcribestreaming.model.MedicalEntity.wrap(buildAwsValue())
}
object MedicalEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.MedicalEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.MedicalEntity =
      zio.aws.transcribestreaming.model.MedicalEntity(
        startTime.map(value => value),
        endTime.map(value => value),
        category.map(value => value),
        content.map(value => value),
        confidence.map(value => value)
      )
    def startTime: Optional[Double]
    def endTime: Optional[Double]
    def category: Optional[String]
    def content: Optional[String]
    def confidence: Optional[Confidence]
    def getStartTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCategory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("category", category)
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getConfidence: ZIO[Any, AwsError, Confidence] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalEntity
  ) extends zio.aws.transcribestreaming.model.MedicalEntity.ReadOnly {
    override val startTime: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: Double)
    override val endTime: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: Double)
    override val category: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value => value: String)
    override val content: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => value: String)
    override val confidence: Optional[Confidence] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.Confidence(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalEntity
  ): zio.aws.transcribestreaming.model.MedicalEntity.ReadOnly = new Wrapper(
    impl
  )
}
