package zio.aws.transcribestreaming.model
import scala.jdk.CollectionConverters.*
sealed trait MediaEncoding {
  def unwrap
      : software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding
}
object MediaEncoding {
  def wrap(
      value: software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding
  ): zio.aws.transcribestreaming.model.MediaEncoding = value match {
    case software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding.PCM =>
      val r = pcm
      r
    case software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding.OGG_OPUS =>
      val r = `ogg-opus`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding.FLAC =>
      val r = flac
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribestreaming.model.MediaEncoding {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding =
      software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding.UNKNOWN_TO_SDK_VERSION
  }
  case object pcm extends zio.aws.transcribestreaming.model.MediaEncoding {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding =
      software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding.PCM
  }
  case object `ogg-opus`
      extends zio.aws.transcribestreaming.model.MediaEncoding {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding =
      software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding.OGG_OPUS
  }
  case object flac extends zio.aws.transcribestreaming.model.MediaEncoding {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding =
      software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding.FLAC
  }
}
