package zio.aws.transcribestreaming.model
import scala.jdk.CollectionConverters.*
sealed trait LanguageCode {
  def unwrap
      : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode
}
object LanguageCode {
  def wrap(
      value: software.amazon.awssdk.services.transcribestreaming.model.LanguageCode
  ): zio.aws.transcribestreaming.model.LanguageCode = value match {
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.EN_US =>
      val r = `en-US`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.EN_GB =>
      val r = `en-GB`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.ES_US =>
      val r = `es-US`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.FR_CA =>
      val r = `fr-CA`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.FR_FR =>
      val r = `fr-FR`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.EN_AU =>
      val r = `en-AU`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.IT_IT =>
      val r = `it-IT`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.DE_DE =>
      val r = `de-DE`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.PT_BR =>
      val r = `pt-BR`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.JA_JP =>
      val r = `ja-JP`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.KO_KR =>
      val r = `ko-KR`
      r
    case software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.ZH_CN =>
      val r = `zh-CN`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `en-US` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.EN_US
  }
  case object `en-GB` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.EN_GB
  }
  case object `es-US` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.ES_US
  }
  case object `fr-CA` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.FR_CA
  }
  case object `fr-FR` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.FR_FR
  }
  case object `en-AU` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.EN_AU
  }
  case object `it-IT` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.IT_IT
  }
  case object `de-DE` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.DE_DE
  }
  case object `pt-BR` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.PT_BR
  }
  case object `ja-JP` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.JA_JP
  }
  case object `ko-KR` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.KO_KR
  }
  case object `zh-CN` extends zio.aws.transcribestreaming.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.LanguageCode =
      software.amazon.awssdk.services.transcribestreaming.model.LanguageCode.ZH_CN
  }
}
