package zio.aws.transcribestreaming.model
import scala.jdk.CollectionConverters.*
sealed trait ItemType {
  def unwrap: software.amazon.awssdk.services.transcribestreaming.model.ItemType
}
object ItemType {
  def wrap(
      value: software.amazon.awssdk.services.transcribestreaming.model.ItemType
  ): zio.aws.transcribestreaming.model.ItemType = value match {
    case software.amazon.awssdk.services.transcribestreaming.model.ItemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribestreaming.model.ItemType.PRONUNCIATION =>
      val r = pronunciation
      r
    case software.amazon.awssdk.services.transcribestreaming.model.ItemType.PUNCTUATION =>
      val r = punctuation
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribestreaming.model.ItemType {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.ItemType =
      software.amazon.awssdk.services.transcribestreaming.model.ItemType.UNKNOWN_TO_SDK_VERSION
  }
  case object pronunciation extends zio.aws.transcribestreaming.model.ItemType {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.ItemType =
      software.amazon.awssdk.services.transcribestreaming.model.ItemType.PRONUNCIATION
  }
  case object punctuation extends zio.aws.transcribestreaming.model.ItemType {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.ItemType =
      software.amazon.awssdk.services.transcribestreaming.model.ItemType.PUNCTUATION
  }
}
