package zio.aws.transcribestreaming.model
import scala.jdk.CollectionConverters.*
sealed trait ContentIdentificationType {
  def unwrap: software.amazon.awssdk.services.transcribestreaming.model.ContentIdentificationType
}
object ContentIdentificationType {
  def wrap(
      value: software.amazon.awssdk.services.transcribestreaming.model.ContentIdentificationType
  ): zio.aws.transcribestreaming.model.ContentIdentificationType = value match {
    case software.amazon.awssdk.services.transcribestreaming.model.ContentIdentificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribestreaming.model.ContentIdentificationType.PII =>
      val r = PII
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribestreaming.model.ContentIdentificationType {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.ContentIdentificationType =
      software.amazon.awssdk.services.transcribestreaming.model.ContentIdentificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object PII
      extends zio.aws.transcribestreaming.model.ContentIdentificationType {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.ContentIdentificationType =
      software.amazon.awssdk.services.transcribestreaming.model.ContentIdentificationType.PII
  }
}
