package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Alternative(
    transcript: Optional[String] = Optional.Absent,
    items: Optional[Iterable[zio.aws.transcribestreaming.model.Item]] =
      Optional.Absent,
    entities: Optional[Iterable[zio.aws.transcribestreaming.model.Entity]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.Alternative = {
    import Alternative.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.Alternative
      .builder()
      .optionallyWith(transcript.map(value => value: java.lang.String))(
        _.transcript
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.Alternative.ReadOnly =
    zio.aws.transcribestreaming.model.Alternative.wrap(buildAwsValue())
}
object Alternative {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.Alternative
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.Alternative =
      zio.aws.transcribestreaming.model.Alternative(
        transcript.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transcript: Optional[String]
    def items: Optional[List[zio.aws.transcribestreaming.model.Item.ReadOnly]]
    def entities
        : Optional[List[zio.aws.transcribestreaming.model.Entity.ReadOnly]]
    def getTranscript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transcript", transcript)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.Item.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getEntities: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.Entity.ReadOnly
    ]] = AwsError.unwrapOptionField("entities", entities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Alternative
  ) extends zio.aws.transcribestreaming.model.Alternative.ReadOnly {
    override val transcript: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transcript())
      .map(value => value: String)
    override val items
        : Optional[List[zio.aws.transcribestreaming.model.Item.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribestreaming.model.Item.wrap(item)
          }.toList
        )
    override val entities
        : Optional[List[zio.aws.transcribestreaming.model.Entity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribestreaming.model.Entity.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Alternative
  ): zio.aws.transcribestreaming.model.Alternative.ReadOnly = new Wrapper(impl)
}
