package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UtteranceEvent(
    utteranceId: Optional[String] = Optional.Absent,
    isPartial: Optional[Boolean] = Optional.Absent,
    participantRole: Optional[
      zio.aws.transcribestreaming.model.ParticipantRole
    ] = Optional.Absent,
    beginOffsetMillis: Optional[Long] = Optional.Absent,
    endOffsetMillis: Optional[Long] = Optional.Absent,
    transcript: Optional[String] = Optional.Absent,
    items: Optional[
      Iterable[zio.aws.transcribestreaming.model.CallAnalyticsItem]
    ] = Optional.Absent,
    entities: Optional[
      Iterable[zio.aws.transcribestreaming.model.CallAnalyticsEntity]
    ] = Optional.Absent,
    sentiment: Optional[zio.aws.transcribestreaming.model.Sentiment] =
      Optional.Absent,
    issuesDetected: Optional[
      Iterable[zio.aws.transcribestreaming.model.IssueDetected]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.UtteranceEvent = {
    import UtteranceEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.UtteranceEvent
      .builder()
      .optionallyWith(utteranceId.map(value => value: java.lang.String))(
        _.utteranceId
      )
      .optionallyWith(isPartial.map(value => value: java.lang.Boolean))(
        _.isPartial
      )
      .optionallyWith(participantRole.map(value => value.unwrap))(
        _.participantRole
      )
      .optionallyWith(beginOffsetMillis.map(value => value: java.lang.Long))(
        _.beginOffsetMillis
      )
      .optionallyWith(endOffsetMillis.map(value => value: java.lang.Long))(
        _.endOffsetMillis
      )
      .optionallyWith(transcript.map(value => value: java.lang.String))(
        _.transcript
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .optionallyWith(sentiment.map(value => value.unwrap))(_.sentiment)
      .optionallyWith(
        issuesDetected.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.issuesDetected)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.UtteranceEvent.ReadOnly =
    zio.aws.transcribestreaming.model.UtteranceEvent.wrap(buildAwsValue())
}
object UtteranceEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.UtteranceEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.UtteranceEvent =
      zio.aws.transcribestreaming.model.UtteranceEvent(
        utteranceId.map(value => value),
        isPartial.map(value => value),
        participantRole.map(value => value),
        beginOffsetMillis.map(value => value),
        endOffsetMillis.map(value => value),
        transcript.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sentiment.map(value => value),
        issuesDetected.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def utteranceId: Optional[String]
    def isPartial: Optional[Boolean]
    def participantRole
        : Optional[zio.aws.transcribestreaming.model.ParticipantRole]
    def beginOffsetMillis: Optional[Long]
    def endOffsetMillis: Optional[Long]
    def transcript: Optional[String]
    def items: Optional[
      List[zio.aws.transcribestreaming.model.CallAnalyticsItem.ReadOnly]
    ]
    def entities: Optional[
      List[zio.aws.transcribestreaming.model.CallAnalyticsEntity.ReadOnly]
    ]
    def sentiment: Optional[zio.aws.transcribestreaming.model.Sentiment]
    def issuesDetected: Optional[
      List[zio.aws.transcribestreaming.model.IssueDetected.ReadOnly]
    ]
    def getUtteranceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("utteranceId", utteranceId)
    def getIsPartial: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPartial", isPartial)
    def getParticipantRole: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.ParticipantRole
    ] = AwsError.unwrapOptionField("participantRole", participantRole)
    def getBeginOffsetMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("beginOffsetMillis", beginOffsetMillis)
    def getEndOffsetMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("endOffsetMillis", endOffsetMillis)
    def getTranscript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transcript", transcript)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.CallAnalyticsItem.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getEntities: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.CallAnalyticsEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("entities", entities)
    def getSentiment
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.Sentiment] =
      AwsError.unwrapOptionField("sentiment", sentiment)
    def getIssuesDetected: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.IssueDetected.ReadOnly
    ]] = AwsError.unwrapOptionField("issuesDetected", issuesDetected)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.UtteranceEvent
  ) extends zio.aws.transcribestreaming.model.UtteranceEvent.ReadOnly {
    override val utteranceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.utteranceId())
      .map(value => value: String)
    override val isPartial: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPartial())
      .map(value => value: Boolean)
    override val participantRole
        : Optional[zio.aws.transcribestreaming.model.ParticipantRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantRole())
        .map(value =>
          zio.aws.transcribestreaming.model.ParticipantRole.wrap(value)
        )
    override val beginOffsetMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffsetMillis())
      .map(value => value: Long)
    override val endOffsetMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffsetMillis())
      .map(value => value: Long)
    override val transcript: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transcript())
      .map(value => value: String)
    override val items: Optional[
      List[zio.aws.transcribestreaming.model.CallAnalyticsItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.CallAnalyticsItem.wrap(item)
        }.toList
      )
    override val entities: Optional[
      List[zio.aws.transcribestreaming.model.CallAnalyticsEntity.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.CallAnalyticsEntity.wrap(item)
        }.toList
      )
    override val sentiment
        : Optional[zio.aws.transcribestreaming.model.Sentiment] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sentiment())
        .map(value => zio.aws.transcribestreaming.model.Sentiment.wrap(value))
    override val issuesDetected: Optional[
      List[zio.aws.transcribestreaming.model.IssueDetected.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.issuesDetected())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.IssueDetected.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.UtteranceEvent
  ): zio.aws.transcribestreaming.model.UtteranceEvent.ReadOnly = new Wrapper(
    impl
  )
}
