package zio.aws.transcribestreaming.model
import scala.jdk.CollectionConverters._
sealed trait ParticipantRole {
  def unwrap: software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole
}
object ParticipantRole {
  def wrap(
      value: software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole
  ): zio.aws.transcribestreaming.model.ParticipantRole = value match {
    case software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole.AGENT =>
      val r = AGENT
      r
    case software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole.CUSTOMER =>
      val r = CUSTOMER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribestreaming.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole =
      software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole.UNKNOWN_TO_SDK_VERSION
  }
  case object AGENT extends zio.aws.transcribestreaming.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole =
      software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole.AGENT
  }
  case object CUSTOMER
      extends zio.aws.transcribestreaming.model.ParticipantRole {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole =
      software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole.CUSTOMER
  }
}
