package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MedicalAlternative(
    transcript: Optional[String] = Optional.Absent,
    items: Optional[Iterable[zio.aws.transcribestreaming.model.MedicalItem]] =
      Optional.Absent,
    entities: Optional[
      Iterable[zio.aws.transcribestreaming.model.MedicalEntity]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.MedicalAlternative = {
    import MedicalAlternative.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.MedicalAlternative
      .builder()
      .optionallyWith(transcript.map(value => value: java.lang.String))(
        _.transcript
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribestreaming.model.MedicalAlternative.ReadOnly =
    zio.aws.transcribestreaming.model.MedicalAlternative.wrap(buildAwsValue())
}
object MedicalAlternative {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.MedicalAlternative
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.MedicalAlternative =
      zio.aws.transcribestreaming.model.MedicalAlternative(
        transcript.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transcript: Optional[String]
    def items
        : Optional[List[zio.aws.transcribestreaming.model.MedicalItem.ReadOnly]]
    def entities: Optional[
      List[zio.aws.transcribestreaming.model.MedicalEntity.ReadOnly]
    ]
    def getTranscript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transcript", transcript)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.MedicalItem.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getEntities: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.MedicalEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("entities", entities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalAlternative
  ) extends zio.aws.transcribestreaming.model.MedicalAlternative.ReadOnly {
    override val transcript: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transcript())
      .map(value => value: String)
    override val items: Optional[
      List[zio.aws.transcribestreaming.model.MedicalItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.MedicalItem.wrap(item)
        }.toList
      )
    override val entities: Optional[
      List[zio.aws.transcribestreaming.model.MedicalEntity.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.MedicalEntity.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalAlternative
  ): zio.aws.transcribestreaming.model.MedicalAlternative.ReadOnly =
    new Wrapper(impl)
}
