package zio.aws.transcribestreaming.model
import zio.aws.transcribestreaming.model.primitives.{Stable, Confidence}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Item(
    startTime: Optional[Double] = Optional.Absent,
    endTime: Optional[Double] = Optional.Absent,
    `type`: Optional[zio.aws.transcribestreaming.model.ItemType] =
      Optional.Absent,
    content: Optional[String] = Optional.Absent,
    vocabularyFilterMatch: Optional[Boolean] = Optional.Absent,
    speaker: Optional[String] = Optional.Absent,
    confidence: Optional[Confidence] = Optional.Absent,
    stable: Optional[Stable] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.Item = {
    import Item.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.Item
      .builder()
      .optionallyWith(startTime.map(value => value: java.lang.Double))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => value: java.lang.Double))(_.endTime)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(
        vocabularyFilterMatch.map(value => value: java.lang.Boolean)
      )(_.vocabularyFilterMatch)
      .optionallyWith(speaker.map(value => value: java.lang.String))(_.speaker)
      .optionallyWith(
        confidence.map(value => Confidence.unwrap(value): java.lang.Double)
      )(_.confidence)
      .optionallyWith(
        stable.map(value => Stable.unwrap(value): java.lang.Boolean)
      )(_.stable)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.Item.ReadOnly =
    zio.aws.transcribestreaming.model.Item.wrap(buildAwsValue())
}
object Item {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.Item
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.Item =
      zio.aws.transcribestreaming.model.Item(
        startTime.map(value => value),
        endTime.map(value => value),
        `type`.map(value => value),
        content.map(value => value),
        vocabularyFilterMatch.map(value => value),
        speaker.map(value => value),
        confidence.map(value => value),
        stable.map(value => value)
      )
    def startTime: Optional[Double]
    def endTime: Optional[Double]
    def `type`: Optional[zio.aws.transcribestreaming.model.ItemType]
    def content: Optional[String]
    def vocabularyFilterMatch: Optional[Boolean]
    def speaker: Optional[String]
    def confidence: Optional[Confidence]
    def stable: Optional[Stable]
    def getStartTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getType
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.ItemType] =
      AwsError.unwrapOptionField("type", `type`)
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getVocabularyFilterMatch: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("vocabularyFilterMatch", vocabularyFilterMatch)
    def getSpeaker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("speaker", speaker)
    def getConfidence: ZIO[Any, AwsError, Confidence] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getStable: ZIO[Any, AwsError, Stable] =
      AwsError.unwrapOptionField("stable", stable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Item
  ) extends zio.aws.transcribestreaming.model.Item.ReadOnly {
    override val startTime: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: Double)
    override val endTime: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: Double)
    override val `type`: Optional[zio.aws.transcribestreaming.model.ItemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.transcribestreaming.model.ItemType.wrap(value))
    override val content: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => value: String)
    override val vocabularyFilterMatch: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterMatch())
        .map(value => value: Boolean)
    override val speaker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.speaker())
      .map(value => value: String)
    override val confidence: Optional[Confidence] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.Confidence(value)
      )
    override val stable: Optional[Stable] = zio.aws.core.internal
      .optionalFromNullable(impl.stable())
      .map(value => zio.aws.transcribestreaming.model.primitives.Stable(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Item
  ): zio.aws.transcribestreaming.model.Item.ReadOnly = new Wrapper(impl)
}
