package zio.aws.transcribestreaming.model
import zio.aws.transcribestreaming.model.primitives.Confidence
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CallAnalyticsEntity(
    beginOffsetMillis: Optional[Long] = Optional.Absent,
    endOffsetMillis: Optional[Long] = Optional.Absent,
    category: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    content: Optional[String] = Optional.Absent,
    confidence: Optional[Confidence] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntity = {
    import CallAnalyticsEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntity
      .builder()
      .optionallyWith(beginOffsetMillis.map(value => value: java.lang.Long))(
        _.beginOffsetMillis
      )
      .optionallyWith(endOffsetMillis.map(value => value: java.lang.Long))(
        _.endOffsetMillis
      )
      .optionallyWith(category.map(value => value: java.lang.String))(
        _.category
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(
        confidence.map(value => Confidence.unwrap(value): java.lang.Double)
      )(_.confidence)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribestreaming.model.CallAnalyticsEntity.ReadOnly =
    zio.aws.transcribestreaming.model.CallAnalyticsEntity.wrap(buildAwsValue())
}
object CallAnalyticsEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.CallAnalyticsEntity =
      zio.aws.transcribestreaming.model.CallAnalyticsEntity(
        beginOffsetMillis.map(value => value),
        endOffsetMillis.map(value => value),
        category.map(value => value),
        `type`.map(value => value),
        content.map(value => value),
        confidence.map(value => value)
      )
    def beginOffsetMillis: Optional[Long]
    def endOffsetMillis: Optional[Long]
    def category: Optional[String]
    def `type`: Optional[String]
    def content: Optional[String]
    def confidence: Optional[Confidence]
    def getBeginOffsetMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("beginOffsetMillis", beginOffsetMillis)
    def getEndOffsetMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("endOffsetMillis", endOffsetMillis)
    def getCategory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("category", category)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getConfidence: ZIO[Any, AwsError, Confidence] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntity
  ) extends zio.aws.transcribestreaming.model.CallAnalyticsEntity.ReadOnly {
    override val beginOffsetMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffsetMillis())
      .map(value => value: Long)
    override val endOffsetMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffsetMillis())
      .map(value => value: Long)
    override val category: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val content: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => value: String)
    override val confidence: Optional[Confidence] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.Confidence(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntity
  ): zio.aws.transcribestreaming.model.CallAnalyticsEntity.ReadOnly =
    new Wrapper(impl)
}
