package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Transcript(
    results: Optional[Iterable[zio.aws.transcribestreaming.model.Result]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.Transcript = {
    import Transcript.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.Transcript
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.Transcript.ReadOnly =
    zio.aws.transcribestreaming.model.Transcript.wrap(buildAwsValue())
}
object Transcript {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.Transcript
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.Transcript =
      zio.aws.transcribestreaming.model.Transcript(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def results
        : Optional[List[zio.aws.transcribestreaming.model.Result.ReadOnly]]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.Result.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Transcript
  ) extends zio.aws.transcribestreaming.model.Transcript.ReadOnly {
    override val results
        : Optional[List[zio.aws.transcribestreaming.model.Result.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.results())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribestreaming.model.Result.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Transcript
  ): zio.aws.transcribestreaming.model.Transcript.ReadOnly = new Wrapper(impl)
}
