package zio.aws.transcribestreaming.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.transcribestreaming.model.primitives.{
  MediaSampleRateHertz,
  VocabularyName,
  VocabularyFilterName,
  ModelName,
  SessionId,
  PiiEntityTypes
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StartCallAnalyticsStreamTranscriptionRequest(
    languageCode: zio.aws.transcribestreaming.model.CallAnalyticsLanguageCode,
    mediaSampleRateHertz: MediaSampleRateHertz,
    mediaEncoding: zio.aws.transcribestreaming.model.MediaEncoding,
    vocabularyName: Optional[VocabularyName] = Optional.Absent,
    sessionId: Optional[SessionId] = Optional.Absent,
    vocabularyFilterName: Optional[VocabularyFilterName] = Optional.Absent,
    vocabularyFilterMethod: Optional[
      zio.aws.transcribestreaming.model.VocabularyFilterMethod
    ] = Optional.Absent,
    languageModelName: Optional[ModelName] = Optional.Absent,
    enablePartialResultsStabilization: Optional[Boolean] = Optional.Absent,
    partialResultsStability: Optional[
      zio.aws.transcribestreaming.model.PartialResultsStability
    ] = Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.transcribestreaming.model.ContentIdentificationType
    ] = Optional.Absent,
    contentRedactionType: Optional[
      zio.aws.transcribestreaming.model.ContentRedactionType
    ] = Optional.Absent,
    piiEntityTypes: Optional[PiiEntityTypes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionRequest = {
    import StartCallAnalyticsStreamTranscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionRequest
      .builder()
      .languageCode(languageCode.unwrap)
      .mediaSampleRateHertz(
        MediaSampleRateHertz.unwrap(mediaSampleRateHertz): Integer
      )
      .mediaEncoding(mediaEncoding.unwrap)
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(vocabularyFilterMethod.map(value => value.unwrap))(
        _.vocabularyFilterMethod
      )
      .optionallyWith(
        languageModelName.map(value =>
          ModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .optionallyWith(
        enablePartialResultsStabilization.map(value => value: java.lang.Boolean)
      )(_.enablePartialResultsStabilization)
      .optionallyWith(partialResultsStability.map(value => value.unwrap))(
        _.partialResultsStability
      )
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(contentRedactionType.map(value => value.unwrap))(
        _.contentRedactionType
      )
      .optionallyWith(
        piiEntityTypes.map(value =>
          PiiEntityTypes.unwrap(value): java.lang.String
        )
      )(_.piiEntityTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionRequest.ReadOnly =
    zio.aws.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionRequest
      .wrap(buildAwsValue())
}
object StartCallAnalyticsStreamTranscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionRequest =
      zio.aws.transcribestreaming.model
        .StartCallAnalyticsStreamTranscriptionRequest(
          languageCode,
          mediaSampleRateHertz,
          mediaEncoding,
          vocabularyName.map(value => value),
          sessionId.map(value => value),
          vocabularyFilterName.map(value => value),
          vocabularyFilterMethod.map(value => value),
          languageModelName.map(value => value),
          enablePartialResultsStabilization.map(value => value),
          partialResultsStability.map(value => value),
          contentIdentificationType.map(value => value),
          contentRedactionType.map(value => value),
          piiEntityTypes.map(value => value)
        )
    def languageCode
        : zio.aws.transcribestreaming.model.CallAnalyticsLanguageCode
    def mediaSampleRateHertz: MediaSampleRateHertz
    def mediaEncoding: zio.aws.transcribestreaming.model.MediaEncoding
    def vocabularyName: Optional[VocabularyName]
    def sessionId: Optional[SessionId]
    def vocabularyFilterName: Optional[VocabularyFilterName]
    def vocabularyFilterMethod
        : Optional[zio.aws.transcribestreaming.model.VocabularyFilterMethod]
    def languageModelName: Optional[ModelName]
    def enablePartialResultsStabilization: Optional[Boolean]
    def partialResultsStability
        : Optional[zio.aws.transcribestreaming.model.PartialResultsStability]
    def contentIdentificationType
        : Optional[zio.aws.transcribestreaming.model.ContentIdentificationType]
    def contentRedactionType
        : Optional[zio.aws.transcribestreaming.model.ContentRedactionType]
    def piiEntityTypes: Optional[PiiEntityTypes]
    def getLanguageCode: ZIO[
      Any,
      Nothing,
      zio.aws.transcribestreaming.model.CallAnalyticsLanguageCode
    ] = ZIO.succeed(languageCode)
    def getMediaSampleRateHertz: ZIO[Any, Nothing, MediaSampleRateHertz] =
      ZIO.succeed(mediaSampleRateHertz)
    def getMediaEncoding
        : ZIO[Any, Nothing, zio.aws.transcribestreaming.model.MediaEncoding] =
      ZIO.succeed(mediaEncoding)
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getVocabularyFilterMethod: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.VocabularyFilterMethod
    ] = AwsError.unwrapOptionField(
      "vocabularyFilterMethod",
      vocabularyFilterMethod
    )
    def getLanguageModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
    def getEnablePartialResultsStabilization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enablePartialResultsStabilization",
        enablePartialResultsStabilization
      )
    def getPartialResultsStability: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.PartialResultsStability
    ] = AwsError.unwrapOptionField(
      "partialResultsStability",
      partialResultsStability
    )
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.ContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getContentRedactionType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.ContentRedactionType
    ] = AwsError.unwrapOptionField("contentRedactionType", contentRedactionType)
    def getPiiEntityTypes: ZIO[Any, AwsError, PiiEntityTypes] =
      AwsError.unwrapOptionField("piiEntityTypes", piiEntityTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionRequest
  ) extends zio.aws.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionRequest.ReadOnly {
    override val languageCode
        : zio.aws.transcribestreaming.model.CallAnalyticsLanguageCode =
      zio.aws.transcribestreaming.model.CallAnalyticsLanguageCode
        .wrap(impl.languageCode())
    override val mediaSampleRateHertz: MediaSampleRateHertz =
      zio.aws.transcribestreaming.model.primitives
        .MediaSampleRateHertz(impl.mediaSampleRateHertz())
    override val mediaEncoding
        : zio.aws.transcribestreaming.model.MediaEncoding =
      zio.aws.transcribestreaming.model.MediaEncoding.wrap(impl.mediaEncoding())
    override val vocabularyName: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyName())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives.VocabularyName(value)
        )
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.SessionId(value)
      )
    override val vocabularyFilterName: Optional[VocabularyFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterName())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives
            .VocabularyFilterName(value)
        )
    override val vocabularyFilterMethod
        : Optional[zio.aws.transcribestreaming.model.VocabularyFilterMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterMethod())
        .map(value =>
          zio.aws.transcribestreaming.model.VocabularyFilterMethod.wrap(value)
        )
    override val languageModelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.languageModelName())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.ModelName(value)
      )
    override val enablePartialResultsStabilization: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePartialResultsStabilization())
        .map(value => value: Boolean)
    override val partialResultsStability
        : Optional[zio.aws.transcribestreaming.model.PartialResultsStability] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partialResultsStability())
        .map(value =>
          zio.aws.transcribestreaming.model.PartialResultsStability.wrap(value)
        )
    override val contentIdentificationType: Optional[
      zio.aws.transcribestreaming.model.ContentIdentificationType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentIdentificationType())
      .map(value =>
        zio.aws.transcribestreaming.model.ContentIdentificationType.wrap(value)
      )
    override val contentRedactionType
        : Optional[zio.aws.transcribestreaming.model.ContentRedactionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRedactionType())
        .map(value =>
          zio.aws.transcribestreaming.model.ContentRedactionType.wrap(value)
        )
    override val piiEntityTypes: Optional[PiiEntityTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.piiEntityTypes())
        .map(value =>
          zio.aws.transcribestreaming.model.primitives.PiiEntityTypes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionRequest
  ): zio.aws.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
