package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PostCallAnalyticsSettings(
    outputLocation: String,
    dataAccessRoleArn: String,
    contentRedactionOutput: Optional[
      zio.aws.transcribestreaming.model.ContentRedactionOutput
    ] = Optional.Absent,
    outputEncryptionKMSKeyId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.PostCallAnalyticsSettings = {
    import PostCallAnalyticsSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.PostCallAnalyticsSettings
      .builder()
      .outputLocation(outputLocation: java.lang.String)
      .dataAccessRoleArn(dataAccessRoleArn: java.lang.String)
      .optionallyWith(contentRedactionOutput.map(value => value.unwrap))(
        _.contentRedactionOutput
      )
      .optionallyWith(
        outputEncryptionKMSKeyId.map(value => value: java.lang.String)
      )(_.outputEncryptionKMSKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribestreaming.model.PostCallAnalyticsSettings.ReadOnly =
    zio.aws.transcribestreaming.model.PostCallAnalyticsSettings
      .wrap(buildAwsValue())
}
object PostCallAnalyticsSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.PostCallAnalyticsSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribestreaming.model.PostCallAnalyticsSettings =
      zio.aws.transcribestreaming.model.PostCallAnalyticsSettings(
        outputLocation,
        dataAccessRoleArn,
        contentRedactionOutput.map(value => value),
        outputEncryptionKMSKeyId.map(value => value)
      )
    def outputLocation: String
    def dataAccessRoleArn: String
    def contentRedactionOutput
        : Optional[zio.aws.transcribestreaming.model.ContentRedactionOutput]
    def outputEncryptionKMSKeyId: Optional[String]
    def getOutputLocation: ZIO[Any, Nothing, String] =
      ZIO.succeed(outputLocation)
    def getDataAccessRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(dataAccessRoleArn)
    def getContentRedactionOutput: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.ContentRedactionOutput
    ] = AwsError.unwrapOptionField(
      "contentRedactionOutput",
      contentRedactionOutput
    )
    def getOutputEncryptionKMSKeyId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("outputEncryptionKMSKeyId", outputEncryptionKMSKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.PostCallAnalyticsSettings
  ) extends zio.aws.transcribestreaming.model.PostCallAnalyticsSettings.ReadOnly {
    override val outputLocation: String = impl.outputLocation(): String
    override val dataAccessRoleArn: String = impl.dataAccessRoleArn(): String
    override val contentRedactionOutput
        : Optional[zio.aws.transcribestreaming.model.ContentRedactionOutput] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRedactionOutput())
        .map(value =>
          zio.aws.transcribestreaming.model.ContentRedactionOutput.wrap(value)
        )
    override val outputEncryptionKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputEncryptionKMSKeyId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.PostCallAnalyticsSettings
  ): zio.aws.transcribestreaming.model.PostCallAnalyticsSettings.ReadOnly =
    new Wrapper(impl)
}
