package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MedicalTranscriptEvent(
    transcript: Optional[zio.aws.transcribestreaming.model.MedicalTranscript] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.MedicalTranscriptEvent = {
    import MedicalTranscriptEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.MedicalTranscriptEvent
      .builder()
      .optionallyWith(transcript.map(value => value.buildAwsValue()))(
        _.transcript
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribestreaming.model.MedicalTranscriptEvent.ReadOnly =
    zio.aws.transcribestreaming.model.MedicalTranscriptEvent
      .wrap(buildAwsValue())
}
object MedicalTranscriptEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.MedicalTranscriptEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.MedicalTranscriptEvent =
      zio.aws.transcribestreaming.model
        .MedicalTranscriptEvent(transcript.map(value => value.asEditable))
    def transcript
        : Optional[zio.aws.transcribestreaming.model.MedicalTranscript.ReadOnly]
    def getTranscript: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.MedicalTranscript.ReadOnly
    ] = AwsError.unwrapOptionField("transcript", transcript)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalTranscriptEvent
  ) extends zio.aws.transcribestreaming.model.MedicalTranscriptEvent.ReadOnly {
    override val transcript: Optional[
      zio.aws.transcribestreaming.model.MedicalTranscript.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transcript())
      .map(value =>
        zio.aws.transcribestreaming.model.MedicalTranscript.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalTranscriptEvent
  ): zio.aws.transcribestreaming.model.MedicalTranscriptEvent.ReadOnly =
    new Wrapper(impl)
}
