package zio.aws.transcribestreaming.model
import zio.aws.transcribestreaming.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CharacterOffsets(
    begin: Optional[Integer] = Optional.Absent,
    end: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.CharacterOffsets = {
    import CharacterOffsets.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.CharacterOffsets
      .builder()
      .optionallyWith(begin.map(value => value: java.lang.Integer))(_.begin)
      .optionallyWith(end.map(value => value: java.lang.Integer))(_.end)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.CharacterOffsets.ReadOnly =
    zio.aws.transcribestreaming.model.CharacterOffsets.wrap(buildAwsValue())
}
object CharacterOffsets {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.CharacterOffsets
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.CharacterOffsets =
      zio.aws.transcribestreaming.model
        .CharacterOffsets(begin.map(value => value), end.map(value => value))
    def begin: Optional[Integer]
    def end: Optional[Integer]
    def getBegin: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("begin", begin)
    def getEnd: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("end", end)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.CharacterOffsets
  ) extends zio.aws.transcribestreaming.model.CharacterOffsets.ReadOnly {
    override val begin: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.begin())
      .map(value => value: Integer)
    override val end: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.CharacterOffsets
  ): zio.aws.transcribestreaming.model.CharacterOffsets.ReadOnly = new Wrapper(
    impl
  )
}
