package zio.aws.transcribestreaming.model
import zio.aws.transcribestreaming.model.primitives.AudioChunk
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AudioEvent(
    audioChunk: Optional[AudioChunk] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.AudioEvent = {
    import AudioEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.AudioEvent
      .builder()
      .optionallyWith(
        audioChunk.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.audioChunk)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.AudioEvent.ReadOnly =
    zio.aws.transcribestreaming.model.AudioEvent.wrap(buildAwsValue())
}
object AudioEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.AudioEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.AudioEvent =
      zio.aws.transcribestreaming.model
        .AudioEvent(audioChunk.map(value => value))
    def audioChunk: Optional[AudioChunk]
    def getAudioChunk: ZIO[Any, AwsError, AudioChunk] =
      AwsError.unwrapOptionField("audioChunk", audioChunk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.AudioEvent
  ) extends zio.aws.transcribestreaming.model.AudioEvent.ReadOnly {
    override val audioChunk: Optional[AudioChunk] = zio.aws.core.internal
      .optionalFromNullable(impl.audioChunk())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives
          .AudioChunk(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.AudioEvent
  ): zio.aws.transcribestreaming.model.AudioEvent.ReadOnly = new Wrapper(impl)
}
