package zio.aws.transcribestreaming
import zio.aws.transcribestreaming.model.UtteranceEvent.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.transcribestreaming.TranscribeStreamingAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.transcribestreaming.model.{
  StartStreamTranscriptionRequest,
  StartMedicalStreamTranscriptionRequest,
  AudioEvent,
  StartCallAnalyticsStreamTranscriptionRequest
}
object TranscribeStreamingMock extends Mock[TranscribeStreaming] {
  object StartCallAnalyticsStreamTranscription
      extends Stream[Tuple2[
        StartCallAnalyticsStreamTranscriptionRequest,
        ZStream[Any, AwsError, AudioEvent]
      ], AwsError, ReadOnly]
  object StartMedicalStreamTranscription
      extends Stream[Tuple2[
        StartMedicalStreamTranscriptionRequest,
        ZStream[Any, AwsError, AudioEvent]
      ], AwsError, zio.aws.transcribestreaming.model.TranscriptEvent.ReadOnly]
  object StartStreamTranscription
      extends Stream[Tuple2[
        StartStreamTranscriptionRequest,
        ZStream[Any, AwsError, AudioEvent]
      ], AwsError, zio.aws.transcribestreaming.model.TranscriptEvent.ReadOnly]
  val compose: URLayer[Proxy, TranscribeStreaming] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, TranscribeStreaming] { rts =>
        zio.ZIO.succeed {
          new TranscribeStreaming {
            val api: TranscribeStreamingAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): TranscribeStreaming = this
            def startCallAnalyticsStreamTranscription(
                request: StartCallAnalyticsStreamTranscriptionRequest,
                input: ZStream[Any, AwsError, AudioEvent]
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(StartCallAnalyticsStreamTranscription, request, input)
                  }
                  .getOrThrowFiberFailure()
              }
            def startMedicalStreamTranscription(
                request: StartMedicalStreamTranscriptionRequest,
                input: ZStream[Any, AwsError, AudioEvent]
            ): ZStream[
              Any,
              AwsError,
              zio.aws.transcribestreaming.model.TranscriptEvent.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(StartMedicalStreamTranscription, request, input)
                }
                .getOrThrowFiberFailure()
            }
            def startStreamTranscription(
                request: StartStreamTranscriptionRequest,
                input: ZStream[Any, AwsError, AudioEvent]
            ): ZStream[
              Any,
              AwsError,
              zio.aws.transcribestreaming.model.TranscriptEvent.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(StartStreamTranscription, request, input)
                }
                .getOrThrowFiberFailure()
            }
          }
        }
      }
    }
  }
}
