package zio.aws.transcribestreaming.model
import scala.jdk.CollectionConverters._
sealed trait Sentiment {
  def unwrap
      : software.amazon.awssdk.services.transcribestreaming.model.Sentiment
}
object Sentiment {
  def wrap(
      value: software.amazon.awssdk.services.transcribestreaming.model.Sentiment
  ): zio.aws.transcribestreaming.model.Sentiment = value match {
    case software.amazon.awssdk.services.transcribestreaming.model.Sentiment.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Sentiment.POSITIVE =>
      val r = POSITIVE
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Sentiment.NEGATIVE =>
      val r = NEGATIVE
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Sentiment.MIXED =>
      val r = MIXED
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Sentiment.NEUTRAL =>
      val r = NEUTRAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribestreaming.model.Sentiment {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Sentiment =
      software.amazon.awssdk.services.transcribestreaming.model.Sentiment.UNKNOWN_TO_SDK_VERSION
  }
  case object POSITIVE extends zio.aws.transcribestreaming.model.Sentiment {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Sentiment =
      software.amazon.awssdk.services.transcribestreaming.model.Sentiment.POSITIVE
  }
  case object NEGATIVE extends zio.aws.transcribestreaming.model.Sentiment {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Sentiment =
      software.amazon.awssdk.services.transcribestreaming.model.Sentiment.NEGATIVE
  }
  case object MIXED extends zio.aws.transcribestreaming.model.Sentiment {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Sentiment =
      software.amazon.awssdk.services.transcribestreaming.model.Sentiment.MIXED
  }
  case object NEUTRAL extends zio.aws.transcribestreaming.model.Sentiment {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Sentiment =
      software.amazon.awssdk.services.transcribestreaming.model.Sentiment.NEUTRAL
  }
}
