package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IssueDetected(
    characterOffsets: Optional[
      zio.aws.transcribestreaming.model.CharacterOffsets
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.IssueDetected = {
    import IssueDetected.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.IssueDetected
      .builder()
      .optionallyWith(characterOffsets.map(value => value.buildAwsValue()))(
        _.characterOffsets
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.IssueDetected.ReadOnly =
    zio.aws.transcribestreaming.model.IssueDetected.wrap(buildAwsValue())
}
object IssueDetected {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.IssueDetected
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.IssueDetected =
      zio.aws.transcribestreaming.model
        .IssueDetected(characterOffsets.map(value => value.asEditable))
    def characterOffsets
        : Optional[zio.aws.transcribestreaming.model.CharacterOffsets.ReadOnly]
    def getCharacterOffsets: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.CharacterOffsets.ReadOnly
    ] = AwsError.unwrapOptionField("characterOffsets", characterOffsets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.IssueDetected
  ) extends zio.aws.transcribestreaming.model.IssueDetected.ReadOnly {
    override val characterOffsets: Optional[
      zio.aws.transcribestreaming.model.CharacterOffsets.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.characterOffsets())
      .map(value =>
        zio.aws.transcribestreaming.model.CharacterOffsets.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.IssueDetected
  ): zio.aws.transcribestreaming.model.IssueDetected.ReadOnly = new Wrapper(
    impl
  )
}
