package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfigurationEvent(
    channelDefinitions: Optional[
      Iterable[zio.aws.transcribestreaming.model.ChannelDefinition]
    ] = Optional.Absent,
    postCallAnalyticsSettings: Optional[
      zio.aws.transcribestreaming.model.PostCallAnalyticsSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.ConfigurationEvent = {
    import ConfigurationEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.ConfigurationEvent
      .builder()
      .optionallyWith(
        channelDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelDefinitions)
      .optionallyWith(
        postCallAnalyticsSettings.map(value => value.buildAwsValue())
      )(_.postCallAnalyticsSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribestreaming.model.ConfigurationEvent.ReadOnly =
    zio.aws.transcribestreaming.model.ConfigurationEvent.wrap(buildAwsValue())
}
object ConfigurationEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.ConfigurationEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.ConfigurationEvent =
      zio.aws.transcribestreaming.model.ConfigurationEvent(
        channelDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        postCallAnalyticsSettings.map(value => value.asEditable)
      )
    def channelDefinitions: Optional[
      List[zio.aws.transcribestreaming.model.ChannelDefinition.ReadOnly]
    ]
    def postCallAnalyticsSettings: Optional[
      zio.aws.transcribestreaming.model.PostCallAnalyticsSettings.ReadOnly
    ]
    def getChannelDefinitions: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.ChannelDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("channelDefinitions", channelDefinitions)
    def getPostCallAnalyticsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.PostCallAnalyticsSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "postCallAnalyticsSettings",
      postCallAnalyticsSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.ConfigurationEvent
  ) extends zio.aws.transcribestreaming.model.ConfigurationEvent.ReadOnly {
    override val channelDefinitions: Optional[
      List[zio.aws.transcribestreaming.model.ChannelDefinition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.channelDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.ChannelDefinition.wrap(item)
        }.toList
      )
    override val postCallAnalyticsSettings: Optional[
      zio.aws.transcribestreaming.model.PostCallAnalyticsSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.postCallAnalyticsSettings())
      .map(value =>
        zio.aws.transcribestreaming.model.PostCallAnalyticsSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.ConfigurationEvent
  ): zio.aws.transcribestreaming.model.ConfigurationEvent.ReadOnly =
    new Wrapper(impl)
}
