package zio.aws.transcribestreaming.model
import java.lang.Integer
import zio.aws.transcribestreaming.model.primitives.ChannelId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ChannelDefinition(
    channelId: ChannelId,
    participantRole: zio.aws.transcribestreaming.model.ParticipantRole
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinition = {
    import ChannelDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinition
      .builder()
      .channelId(ChannelId.unwrap(channelId): Integer)
      .participantRole(participantRole.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.ChannelDefinition.ReadOnly =
    zio.aws.transcribestreaming.model.ChannelDefinition.wrap(buildAwsValue())
}
object ChannelDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.ChannelDefinition =
      zio.aws.transcribestreaming.model
        .ChannelDefinition(channelId, participantRole)
    def channelId: ChannelId
    def participantRole: zio.aws.transcribestreaming.model.ParticipantRole
    def getChannelId: ZIO[Any, Nothing, ChannelId] = ZIO.succeed(channelId)
    def getParticipantRole
        : ZIO[Any, Nothing, zio.aws.transcribestreaming.model.ParticipantRole] =
      ZIO.succeed(participantRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinition
  ) extends zio.aws.transcribestreaming.model.ChannelDefinition.ReadOnly {
    override val channelId: ChannelId =
      zio.aws.transcribestreaming.model.primitives.ChannelId(impl.channelId())
    override val participantRole
        : zio.aws.transcribestreaming.model.ParticipantRole =
      zio.aws.transcribestreaming.model.ParticipantRole
        .wrap(impl.participantRole())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinition
  ): zio.aws.transcribestreaming.model.ChannelDefinition.ReadOnly = new Wrapper(
    impl
  )
}
