package zio.aws.transcribestreaming.model
import zio.aws.transcribestreaming.model.primitives.{Stable, Confidence}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CallAnalyticsItem(
    beginOffsetMillis: Optional[Long] = Optional.Absent,
    endOffsetMillis: Optional[Long] = Optional.Absent,
    `type`: Optional[zio.aws.transcribestreaming.model.ItemType] =
      Optional.Absent,
    content: Optional[String] = Optional.Absent,
    confidence: Optional[Confidence] = Optional.Absent,
    vocabularyFilterMatch: Optional[Boolean] = Optional.Absent,
    stable: Optional[Stable] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItem = {
    import CallAnalyticsItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItem
      .builder()
      .optionallyWith(beginOffsetMillis.map(value => value: java.lang.Long))(
        _.beginOffsetMillis
      )
      .optionallyWith(endOffsetMillis.map(value => value: java.lang.Long))(
        _.endOffsetMillis
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(
        confidence.map(value => Confidence.unwrap(value): java.lang.Double)
      )(_.confidence)
      .optionallyWith(
        vocabularyFilterMatch.map(value => value: java.lang.Boolean)
      )(_.vocabularyFilterMatch)
      .optionallyWith(
        stable.map(value => Stable.unwrap(value): java.lang.Boolean)
      )(_.stable)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.CallAnalyticsItem.ReadOnly =
    zio.aws.transcribestreaming.model.CallAnalyticsItem.wrap(buildAwsValue())
}
object CallAnalyticsItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.CallAnalyticsItem =
      zio.aws.transcribestreaming.model.CallAnalyticsItem(
        beginOffsetMillis.map(value => value),
        endOffsetMillis.map(value => value),
        `type`.map(value => value),
        content.map(value => value),
        confidence.map(value => value),
        vocabularyFilterMatch.map(value => value),
        stable.map(value => value)
      )
    def beginOffsetMillis: Optional[Long]
    def endOffsetMillis: Optional[Long]
    def `type`: Optional[zio.aws.transcribestreaming.model.ItemType]
    def content: Optional[String]
    def confidence: Optional[Confidence]
    def vocabularyFilterMatch: Optional[Boolean]
    def stable: Optional[Stable]
    def getBeginOffsetMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("beginOffsetMillis", beginOffsetMillis)
    def getEndOffsetMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("endOffsetMillis", endOffsetMillis)
    def getType
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.ItemType] =
      AwsError.unwrapOptionField("type", `type`)
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getConfidence: ZIO[Any, AwsError, Confidence] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getVocabularyFilterMatch: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("vocabularyFilterMatch", vocabularyFilterMatch)
    def getStable: ZIO[Any, AwsError, Stable] =
      AwsError.unwrapOptionField("stable", stable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItem
  ) extends zio.aws.transcribestreaming.model.CallAnalyticsItem.ReadOnly {
    override val beginOffsetMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffsetMillis())
      .map(value => value: Long)
    override val endOffsetMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffsetMillis())
      .map(value => value: Long)
    override val `type`: Optional[zio.aws.transcribestreaming.model.ItemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.transcribestreaming.model.ItemType.wrap(value))
    override val content: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => value: String)
    override val confidence: Optional[Confidence] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.Confidence(value)
      )
    override val vocabularyFilterMatch: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterMatch())
        .map(value => value: Boolean)
    override val stable: Optional[Stable] = zio.aws.core.internal
      .optionalFromNullable(impl.stable())
      .map(value => zio.aws.transcribestreaming.model.primitives.Stable(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItem
  ): zio.aws.transcribestreaming.model.CallAnalyticsItem.ReadOnly = new Wrapper(
    impl
  )
}
