package zio.aws.transcribestreaming.model
import scala.jdk.CollectionConverters._
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.transcribestreaming.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.transcribestreaming.model.Type
  ): zio.aws.transcribestreaming.model.Type = value match {
    case software.amazon.awssdk.services.transcribestreaming.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Type.CONVERSATION =>
      val r = CONVERSATION
      r
    case software.amazon.awssdk.services.transcribestreaming.model.Type.DICTATION =>
      val r = DICTATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribestreaming.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Type =
      software.amazon.awssdk.services.transcribestreaming.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object CONVERSATION extends zio.aws.transcribestreaming.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Type =
      software.amazon.awssdk.services.transcribestreaming.model.Type.CONVERSATION
  }
  case object DICTATION extends zio.aws.transcribestreaming.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.Type =
      software.amazon.awssdk.services.transcribestreaming.model.Type.DICTATION
  }
}
