package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TranscriptEvent(
    transcript: Option[zio.aws.transcribestreaming.model.Transcript] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.TranscriptEvent = {
    import TranscriptEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.TranscriptEvent
      .builder()
      .optionallyWith(transcript.map(value => value.buildAwsValue()))(
        _.transcript
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.TranscriptEvent.ReadOnly =
    zio.aws.transcribestreaming.model.TranscriptEvent.wrap(buildAwsValue())
}
object TranscriptEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.TranscriptEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.TranscriptEvent =
      zio.aws.transcribestreaming.model
        .TranscriptEvent(transcript.map(value => value.asEditable))
    def transcript
        : Option[zio.aws.transcribestreaming.model.Transcript.ReadOnly]
    def getTranscript: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.Transcript.ReadOnly
    ] = AwsError.unwrapOptionField("transcript", transcript)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.TranscriptEvent
  ) extends zio.aws.transcribestreaming.model.TranscriptEvent.ReadOnly {
    override val transcript
        : Option[zio.aws.transcribestreaming.model.Transcript.ReadOnly] = scala
      .Option(impl.transcript())
      .map(value => zio.aws.transcribestreaming.model.Transcript.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.TranscriptEvent
  ): zio.aws.transcribestreaming.model.TranscriptEvent.ReadOnly = new Wrapper(
    impl
  )
}
