package zio.aws.transcribestreaming.model
import java.lang.Integer
import zio.aws.transcribestreaming.model.primitives.{
  NumberOfChannels,
  MediaSampleRateHertz,
  LanguageOptions,
  VocabularyName,
  VocabularyFilterName,
  ModelName,
  SessionId,
  PiiEntityTypes
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartStreamTranscriptionRequest(
    languageCode: Option[zio.aws.transcribestreaming.model.LanguageCode] = None,
    mediaSampleRateHertz: MediaSampleRateHertz,
    mediaEncoding: zio.aws.transcribestreaming.model.MediaEncoding,
    vocabularyName: Option[VocabularyName] = None,
    sessionId: Option[SessionId] = None,
    vocabularyFilterName: Option[VocabularyFilterName] = None,
    vocabularyFilterMethod: Option[
      zio.aws.transcribestreaming.model.VocabularyFilterMethod
    ] = None,
    showSpeakerLabel: Option[Boolean] = None,
    enableChannelIdentification: Option[Boolean] = None,
    numberOfChannels: Option[NumberOfChannels] = None,
    enablePartialResultsStabilization: Option[Boolean] = None,
    partialResultsStability: Option[
      zio.aws.transcribestreaming.model.PartialResultsStability
    ] = None,
    contentIdentificationType: Option[
      zio.aws.transcribestreaming.model.ContentIdentificationType
    ] = None,
    contentRedactionType: Option[
      zio.aws.transcribestreaming.model.ContentRedactionType
    ] = None,
    piiEntityTypes: Option[PiiEntityTypes] = None,
    languageModelName: Option[ModelName] = None,
    identifyLanguage: Option[Boolean] = None,
    languageOptions: Option[LanguageOptions] = None,
    preferredLanguage: Option[zio.aws.transcribestreaming.model.LanguageCode] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest = {
    import StartStreamTranscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest
      .builder()
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .mediaSampleRateHertz(
        MediaSampleRateHertz.unwrap(mediaSampleRateHertz): Integer
      )
      .mediaEncoding(mediaEncoding.unwrap)
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(vocabularyFilterMethod.map(value => value.unwrap))(
        _.vocabularyFilterMethod
      )
      .optionallyWith(showSpeakerLabel.map(value => value: java.lang.Boolean))(
        _.showSpeakerLabel
      )
      .optionallyWith(
        enableChannelIdentification.map(value => value: java.lang.Boolean)
      )(_.enableChannelIdentification)
      .optionallyWith(
        numberOfChannels.map(value => NumberOfChannels.unwrap(value): Integer)
      )(_.numberOfChannels)
      .optionallyWith(
        enablePartialResultsStabilization.map(value => value: java.lang.Boolean)
      )(_.enablePartialResultsStabilization)
      .optionallyWith(partialResultsStability.map(value => value.unwrap))(
        _.partialResultsStability
      )
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(contentRedactionType.map(value => value.unwrap))(
        _.contentRedactionType
      )
      .optionallyWith(
        piiEntityTypes.map(value =>
          PiiEntityTypes.unwrap(value): java.lang.String
        )
      )(_.piiEntityTypes)
      .optionallyWith(
        languageModelName.map(value =>
          ModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        languageOptions.map(value =>
          LanguageOptions.unwrap(value): java.lang.String
        )
      )(_.languageOptions)
      .optionallyWith(preferredLanguage.map(value => value.unwrap))(
        _.preferredLanguage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest.ReadOnly =
    zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest
      .wrap(buildAwsValue())
}
object StartStreamTranscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest =
      zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest(
        languageCode.map(value => value),
        mediaSampleRateHertz,
        mediaEncoding,
        vocabularyName.map(value => value),
        sessionId.map(value => value),
        vocabularyFilterName.map(value => value),
        vocabularyFilterMethod.map(value => value),
        showSpeakerLabel.map(value => value),
        enableChannelIdentification.map(value => value),
        numberOfChannels.map(value => value),
        enablePartialResultsStabilization.map(value => value),
        partialResultsStability.map(value => value),
        contentIdentificationType.map(value => value),
        contentRedactionType.map(value => value),
        piiEntityTypes.map(value => value),
        languageModelName.map(value => value),
        identifyLanguage.map(value => value),
        languageOptions.map(value => value),
        preferredLanguage.map(value => value)
      )
    def languageCode: Option[zio.aws.transcribestreaming.model.LanguageCode]
    def mediaSampleRateHertz: MediaSampleRateHertz
    def mediaEncoding: zio.aws.transcribestreaming.model.MediaEncoding
    def vocabularyName: Option[VocabularyName]
    def sessionId: Option[SessionId]
    def vocabularyFilterName: Option[VocabularyFilterName]
    def vocabularyFilterMethod
        : Option[zio.aws.transcribestreaming.model.VocabularyFilterMethod]
    def showSpeakerLabel: Option[Boolean]
    def enableChannelIdentification: Option[Boolean]
    def numberOfChannels: Option[NumberOfChannels]
    def enablePartialResultsStabilization: Option[Boolean]
    def partialResultsStability
        : Option[zio.aws.transcribestreaming.model.PartialResultsStability]
    def contentIdentificationType
        : Option[zio.aws.transcribestreaming.model.ContentIdentificationType]
    def contentRedactionType
        : Option[zio.aws.transcribestreaming.model.ContentRedactionType]
    def piiEntityTypes: Option[PiiEntityTypes]
    def languageModelName: Option[ModelName]
    def identifyLanguage: Option[Boolean]
    def languageOptions: Option[LanguageOptions]
    def preferredLanguage
        : Option[zio.aws.transcribestreaming.model.LanguageCode]
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getMediaSampleRateHertz: ZIO[Any, Nothing, MediaSampleRateHertz] =
      ZIO.succeed(mediaSampleRateHertz)
    def getMediaEncoding
        : ZIO[Any, Nothing, zio.aws.transcribestreaming.model.MediaEncoding] =
      ZIO.succeed(mediaEncoding)
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getVocabularyFilterMethod: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.VocabularyFilterMethod
    ] = AwsError.unwrapOptionField(
      "vocabularyFilterMethod",
      vocabularyFilterMethod
    )
    def getShowSpeakerLabel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showSpeakerLabel", showSpeakerLabel)
    def getEnableChannelIdentification: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableChannelIdentification",
        enableChannelIdentification
      )
    def getNumberOfChannels: ZIO[Any, AwsError, NumberOfChannels] =
      AwsError.unwrapOptionField("numberOfChannels", numberOfChannels)
    def getEnablePartialResultsStabilization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enablePartialResultsStabilization",
        enablePartialResultsStabilization
      )
    def getPartialResultsStability: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.PartialResultsStability
    ] = AwsError.unwrapOptionField(
      "partialResultsStability",
      partialResultsStability
    )
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.ContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getContentRedactionType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribestreaming.model.ContentRedactionType
    ] = AwsError.unwrapOptionField("contentRedactionType", contentRedactionType)
    def getPiiEntityTypes: ZIO[Any, AwsError, PiiEntityTypes] =
      AwsError.unwrapOptionField("piiEntityTypes", piiEntityTypes)
    def getLanguageModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getLanguageOptions: ZIO[Any, AwsError, LanguageOptions] =
      AwsError.unwrapOptionField("languageOptions", languageOptions)
    def getPreferredLanguage
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.LanguageCode] =
      AwsError.unwrapOptionField("preferredLanguage", preferredLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest
  ) extends zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest.ReadOnly {
    override val languageCode
        : Option[zio.aws.transcribestreaming.model.LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.transcribestreaming.model.LanguageCode.wrap(value))
    override val mediaSampleRateHertz: MediaSampleRateHertz =
      zio.aws.transcribestreaming.model.primitives
        .MediaSampleRateHertz(impl.mediaSampleRateHertz())
    override val mediaEncoding
        : zio.aws.transcribestreaming.model.MediaEncoding =
      zio.aws.transcribestreaming.model.MediaEncoding.wrap(impl.mediaEncoding())
    override val vocabularyName: Option[VocabularyName] = scala
      .Option(impl.vocabularyName())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.VocabularyName(value)
      )
    override val sessionId: Option[SessionId] = scala
      .Option(impl.sessionId())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.SessionId(value)
      )
    override val vocabularyFilterName: Option[VocabularyFilterName] = scala
      .Option(impl.vocabularyFilterName())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.VocabularyFilterName(value)
      )
    override val vocabularyFilterMethod
        : Option[zio.aws.transcribestreaming.model.VocabularyFilterMethod] =
      scala
        .Option(impl.vocabularyFilterMethod())
        .map(value =>
          zio.aws.transcribestreaming.model.VocabularyFilterMethod.wrap(value)
        )
    override val showSpeakerLabel: Option[Boolean] =
      scala.Option(impl.showSpeakerLabel()).map(value => value: Boolean)
    override val enableChannelIdentification: Option[Boolean] = scala
      .Option(impl.enableChannelIdentification())
      .map(value => value: Boolean)
    override val numberOfChannels: Option[NumberOfChannels] = scala
      .Option(impl.numberOfChannels())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.NumberOfChannels(value)
      )
    override val enablePartialResultsStabilization: Option[Boolean] = scala
      .Option(impl.enablePartialResultsStabilization())
      .map(value => value: Boolean)
    override val partialResultsStability
        : Option[zio.aws.transcribestreaming.model.PartialResultsStability] =
      scala
        .Option(impl.partialResultsStability())
        .map(value =>
          zio.aws.transcribestreaming.model.PartialResultsStability.wrap(value)
        )
    override val contentIdentificationType
        : Option[zio.aws.transcribestreaming.model.ContentIdentificationType] =
      scala
        .Option(impl.contentIdentificationType())
        .map(value =>
          zio.aws.transcribestreaming.model.ContentIdentificationType
            .wrap(value)
        )
    override val contentRedactionType
        : Option[zio.aws.transcribestreaming.model.ContentRedactionType] = scala
      .Option(impl.contentRedactionType())
      .map(value =>
        zio.aws.transcribestreaming.model.ContentRedactionType.wrap(value)
      )
    override val piiEntityTypes: Option[PiiEntityTypes] = scala
      .Option(impl.piiEntityTypes())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.PiiEntityTypes(value)
      )
    override val languageModelName: Option[ModelName] = scala
      .Option(impl.languageModelName())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.ModelName(value)
      )
    override val identifyLanguage: Option[Boolean] =
      scala.Option(impl.identifyLanguage()).map(value => value: Boolean)
    override val languageOptions: Option[LanguageOptions] = scala
      .Option(impl.languageOptions())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.LanguageOptions(value)
      )
    override val preferredLanguage
        : Option[zio.aws.transcribestreaming.model.LanguageCode] = scala
      .Option(impl.preferredLanguage())
      .map(value => zio.aws.transcribestreaming.model.LanguageCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.StartStreamTranscriptionRequest
  ): zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
