package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LanguageWithScore(
    languageCode: Option[zio.aws.transcribestreaming.model.LanguageCode] = None,
    score: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.LanguageWithScore = {
    import LanguageWithScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.LanguageWithScore
      .builder()
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(score.map(value => value: java.lang.Double))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.LanguageWithScore.ReadOnly =
    zio.aws.transcribestreaming.model.LanguageWithScore.wrap(buildAwsValue())
}
object LanguageWithScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.LanguageWithScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.LanguageWithScore =
      zio.aws.transcribestreaming.model.LanguageWithScore(
        languageCode.map(value => value),
        score.map(value => value)
      )
    def languageCode: Option[zio.aws.transcribestreaming.model.LanguageCode]
    def score: Option[Double]
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getScore: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.LanguageWithScore
  ) extends zio.aws.transcribestreaming.model.LanguageWithScore.ReadOnly {
    override val languageCode
        : Option[zio.aws.transcribestreaming.model.LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.transcribestreaming.model.LanguageCode.wrap(value))
    override val score: Option[Double] =
      scala.Option(impl.score()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.LanguageWithScore
  ): zio.aws.transcribestreaming.model.LanguageWithScore.ReadOnly = new Wrapper(
    impl
  )
}
