package zio.aws.transcribestreaming.model
import zio.aws.transcribestreaming.model.primitives.{Stable, Confidence}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Item(
    startTime: Option[Double] = None,
    endTime: Option[Double] = None,
    `type`: Option[zio.aws.transcribestreaming.model.ItemType] = None,
    content: Option[String] = None,
    vocabularyFilterMatch: Option[Boolean] = None,
    speaker: Option[String] = None,
    confidence: Option[Confidence] = None,
    stable: Option[Stable] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.Item = {
    import Item.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.Item
      .builder()
      .optionallyWith(startTime.map(value => value: java.lang.Double))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => value: java.lang.Double))(_.endTime)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(
        vocabularyFilterMatch.map(value => value: java.lang.Boolean)
      )(_.vocabularyFilterMatch)
      .optionallyWith(speaker.map(value => value: java.lang.String))(_.speaker)
      .optionallyWith(
        confidence.map(value => Confidence.unwrap(value): java.lang.Double)
      )(_.confidence)
      .optionallyWith(
        stable.map(value => Stable.unwrap(value): java.lang.Boolean)
      )(_.stable)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.Item.ReadOnly =
    zio.aws.transcribestreaming.model.Item.wrap(buildAwsValue())
}
object Item {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.Item
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.Item =
      zio.aws.transcribestreaming.model.Item(
        startTime.map(value => value),
        endTime.map(value => value),
        `type`.map(value => value),
        content.map(value => value),
        vocabularyFilterMatch.map(value => value),
        speaker.map(value => value),
        confidence.map(value => value),
        stable.map(value => value)
      )
    def startTime: Option[Double]
    def endTime: Option[Double]
    def `type`: Option[zio.aws.transcribestreaming.model.ItemType]
    def content: Option[String]
    def vocabularyFilterMatch: Option[Boolean]
    def speaker: Option[String]
    def confidence: Option[Confidence]
    def stable: Option[Stable]
    def getStartTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getType
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.ItemType] =
      AwsError.unwrapOptionField("type", `type`)
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getVocabularyFilterMatch: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("vocabularyFilterMatch", vocabularyFilterMatch)
    def getSpeaker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("speaker", speaker)
    def getConfidence: ZIO[Any, AwsError, Confidence] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getStable: ZIO[Any, AwsError, Stable] =
      AwsError.unwrapOptionField("stable", stable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Item
  ) extends zio.aws.transcribestreaming.model.Item.ReadOnly {
    override val startTime: Option[Double] =
      scala.Option(impl.startTime()).map(value => value: Double)
    override val endTime: Option[Double] =
      scala.Option(impl.endTime()).map(value => value: Double)
    override val `type`: Option[zio.aws.transcribestreaming.model.ItemType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.transcribestreaming.model.ItemType.wrap(value))
    override val content: Option[String] =
      scala.Option(impl.content()).map(value => value: String)
    override val vocabularyFilterMatch: Option[Boolean] =
      scala.Option(impl.vocabularyFilterMatch()).map(value => value: Boolean)
    override val speaker: Option[String] =
      scala.Option(impl.speaker()).map(value => value: String)
    override val confidence: Option[Confidence] = scala
      .Option(impl.confidence())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.Confidence(value)
      )
    override val stable: Option[Stable] = scala
      .Option(impl.stable())
      .map(value => zio.aws.transcribestreaming.model.primitives.Stable(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Item
  ): zio.aws.transcribestreaming.model.Item.ReadOnly = new Wrapper(impl)
}
