package zio.aws.transcribestreaming
import zio.mock.{Proxy, Mock}
import zio.aws.transcribestreaming.model.TranscriptEvent.ReadOnly
import zio.aws.core.AwsError
import software.amazon.awssdk.services.transcribestreaming.TranscribeStreamingAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.transcribestreaming.model.{
  StartStreamTranscriptionRequest,
  AudioEvent,
  StartMedicalStreamTranscriptionRequest
}
object TranscribeStreamingMock extends Mock[TranscribeStreaming] {
  object StartMedicalStreamTranscription
      extends Stream[Tuple2[
        StartMedicalStreamTranscriptionRequest,
        ZStream[Any, AwsError, AudioEvent]
      ], AwsError, ReadOnly]
  object StartStreamTranscription
      extends Stream[Tuple2[
        StartStreamTranscriptionRequest,
        ZStream[Any, AwsError, AudioEvent]
      ], AwsError, ReadOnly]
  val compose: URLayer[Proxy, TranscribeStreaming] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new TranscribeStreaming {
          val api: TranscribeStreamingAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : TranscribeStreaming = this
          def startMedicalStreamTranscription(
              request: StartMedicalStreamTranscriptionRequest,
              input: ZStream[Any, AwsError, AudioEvent]
          ): ZStream[Any, AwsError, ReadOnly] = rts.unsafeRun(
            proxy(StartMedicalStreamTranscription, request, input)
          )
          def startStreamTranscription(
              request: StartStreamTranscriptionRequest,
              input: ZStream[Any, AwsError, AudioEvent]
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(StartStreamTranscription, request, input))
        }
      }
    }
    .toLayer
}
