package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Result(
    resultId: Option[String] = None,
    startTime: Option[Double] = None,
    endTime: Option[Double] = None,
    isPartial: Option[Boolean] = None,
    alternatives: Option[
      Iterable[zio.aws.transcribestreaming.model.Alternative]
    ] = None,
    channelId: Option[String] = None,
    languageCode: Option[zio.aws.transcribestreaming.model.LanguageCode] = None,
    languageIdentification: Option[
      Iterable[zio.aws.transcribestreaming.model.LanguageWithScore]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.Result = {
    import Result.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.Result
      .builder()
      .optionallyWith(resultId.map(value => value: java.lang.String))(
        _.resultId
      )
      .optionallyWith(startTime.map(value => value: java.lang.Double))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => value: java.lang.Double))(_.endTime)
      .optionallyWith(isPartial.map(value => value: java.lang.Boolean))(
        _.isPartial
      )
      .optionallyWith(
        alternatives.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternatives)
      .optionallyWith(channelId.map(value => value: java.lang.String))(
        _.channelId
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        languageIdentification.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.languageIdentification)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.Result.ReadOnly =
    zio.aws.transcribestreaming.model.Result.wrap(buildAwsValue())
}
object Result {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.Result
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.Result =
      zio.aws.transcribestreaming.model.Result(
        resultId.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        isPartial.map(value => value),
        alternatives.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        channelId.map(value => value),
        languageCode.map(value => value),
        languageIdentification.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resultId: Option[String]
    def startTime: Option[Double]
    def endTime: Option[Double]
    def isPartial: Option[Boolean]
    def alternatives
        : Option[List[zio.aws.transcribestreaming.model.Alternative.ReadOnly]]
    def channelId: Option[String]
    def languageCode: Option[zio.aws.transcribestreaming.model.LanguageCode]
    def languageIdentification: Option[
      List[zio.aws.transcribestreaming.model.LanguageWithScore.ReadOnly]
    ]
    def getResultId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultId", resultId)
    def getStartTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getIsPartial: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPartial", isPartial)
    def getAlternatives: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.Alternative.ReadOnly
    ]] = AwsError.unwrapOptionField("alternatives", alternatives)
    def getChannelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLanguageIdentification: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.LanguageWithScore.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "languageIdentification",
      languageIdentification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Result
  ) extends zio.aws.transcribestreaming.model.Result.ReadOnly {
    override val resultId: Option[String] =
      scala.Option(impl.resultId()).map(value => value: String)
    override val startTime: Option[Double] =
      scala.Option(impl.startTime()).map(value => value: Double)
    override val endTime: Option[Double] =
      scala.Option(impl.endTime()).map(value => value: Double)
    override val isPartial: Option[Boolean] =
      scala.Option(impl.isPartial()).map(value => value: Boolean)
    override val alternatives
        : Option[List[zio.aws.transcribestreaming.model.Alternative.ReadOnly]] =
      scala
        .Option(impl.alternatives())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribestreaming.model.Alternative.wrap(item)
          }.toList
        )
    override val channelId: Option[String] =
      scala.Option(impl.channelId()).map(value => value: String)
    override val languageCode
        : Option[zio.aws.transcribestreaming.model.LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.transcribestreaming.model.LanguageCode.wrap(value))
    override val languageIdentification: Option[
      List[zio.aws.transcribestreaming.model.LanguageWithScore.ReadOnly]
    ] = scala
      .Option(impl.languageIdentification())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.LanguageWithScore.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Result
  ): zio.aws.transcribestreaming.model.Result.ReadOnly = new Wrapper(impl)
}
