package zio.aws.transcribestreaming.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MedicalResult(
    resultId: Option[String] = None,
    startTime: Option[Double] = None,
    endTime: Option[Double] = None,
    isPartial: Option[Boolean] = None,
    alternatives: Option[
      Iterable[zio.aws.transcribestreaming.model.MedicalAlternative]
    ] = None,
    channelId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.MedicalResult = {
    import MedicalResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.MedicalResult
      .builder()
      .optionallyWith(resultId.map(value => value: java.lang.String))(
        _.resultId
      )
      .optionallyWith(startTime.map(value => value: java.lang.Double))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => value: java.lang.Double))(_.endTime)
      .optionallyWith(isPartial.map(value => value: java.lang.Boolean))(
        _.isPartial
      )
      .optionallyWith(
        alternatives.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternatives)
      .optionallyWith(channelId.map(value => value: java.lang.String))(
        _.channelId
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.MedicalResult.ReadOnly =
    zio.aws.transcribestreaming.model.MedicalResult.wrap(buildAwsValue())
}
object MedicalResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.MedicalResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.MedicalResult =
      zio.aws.transcribestreaming.model.MedicalResult(
        resultId.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        isPartial.map(value => value),
        alternatives.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        channelId.map(value => value)
      )
    def resultId: Option[String]
    def startTime: Option[Double]
    def endTime: Option[Double]
    def isPartial: Option[Boolean]
    def alternatives: Option[
      List[zio.aws.transcribestreaming.model.MedicalAlternative.ReadOnly]
    ]
    def channelId: Option[String]
    def getResultId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultId", resultId)
    def getStartTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getIsPartial: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPartial", isPartial)
    def getAlternatives: ZIO[Any, AwsError, List[
      zio.aws.transcribestreaming.model.MedicalAlternative.ReadOnly
    ]] = AwsError.unwrapOptionField("alternatives", alternatives)
    def getChannelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("channelId", channelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalResult
  ) extends zio.aws.transcribestreaming.model.MedicalResult.ReadOnly {
    override val resultId: Option[String] =
      scala.Option(impl.resultId()).map(value => value: String)
    override val startTime: Option[Double] =
      scala.Option(impl.startTime()).map(value => value: Double)
    override val endTime: Option[Double] =
      scala.Option(impl.endTime()).map(value => value: Double)
    override val isPartial: Option[Boolean] =
      scala.Option(impl.isPartial()).map(value => value: Boolean)
    override val alternatives: Option[
      List[zio.aws.transcribestreaming.model.MedicalAlternative.ReadOnly]
    ] = scala
      .Option(impl.alternatives())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribestreaming.model.MedicalAlternative.wrap(item)
        }.toList
      )
    override val channelId: Option[String] =
      scala.Option(impl.channelId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalResult
  ): zio.aws.transcribestreaming.model.MedicalResult.ReadOnly = new Wrapper(
    impl
  )
}
