package zio.aws.transcribestreaming.model
import zio.aws.transcribestreaming.model.primitives.Confidence
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MedicalItem(
    startTime: Option[Double] = None,
    endTime: Option[Double] = None,
    `type`: Option[zio.aws.transcribestreaming.model.ItemType] = None,
    content: Option[String] = None,
    confidence: Option[Confidence] = None,
    speaker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.MedicalItem = {
    import MedicalItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.MedicalItem
      .builder()
      .optionallyWith(startTime.map(value => value: java.lang.Double))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => value: java.lang.Double))(_.endTime)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(
        confidence.map(value => Confidence.unwrap(value): java.lang.Double)
      )(_.confidence)
      .optionallyWith(speaker.map(value => value: java.lang.String))(_.speaker)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.MedicalItem.ReadOnly =
    zio.aws.transcribestreaming.model.MedicalItem.wrap(buildAwsValue())
}
object MedicalItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.MedicalItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.MedicalItem =
      zio.aws.transcribestreaming.model.MedicalItem(
        startTime.map(value => value),
        endTime.map(value => value),
        `type`.map(value => value),
        content.map(value => value),
        confidence.map(value => value),
        speaker.map(value => value)
      )
    def startTime: Option[Double]
    def endTime: Option[Double]
    def `type`: Option[zio.aws.transcribestreaming.model.ItemType]
    def content: Option[String]
    def confidence: Option[Confidence]
    def speaker: Option[String]
    def getStartTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getType
        : ZIO[Any, AwsError, zio.aws.transcribestreaming.model.ItemType] =
      AwsError.unwrapOptionField("type", `type`)
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getConfidence: ZIO[Any, AwsError, Confidence] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getSpeaker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("speaker", speaker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalItem
  ) extends zio.aws.transcribestreaming.model.MedicalItem.ReadOnly {
    override val startTime: Option[Double] =
      scala.Option(impl.startTime()).map(value => value: Double)
    override val endTime: Option[Double] =
      scala.Option(impl.endTime()).map(value => value: Double)
    override val `type`: Option[zio.aws.transcribestreaming.model.ItemType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.transcribestreaming.model.ItemType.wrap(value))
    override val content: Option[String] =
      scala.Option(impl.content()).map(value => value: String)
    override val confidence: Option[Confidence] = scala
      .Option(impl.confidence())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.Confidence(value)
      )
    override val speaker: Option[String] =
      scala.Option(impl.speaker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.MedicalItem
  ): zio.aws.transcribestreaming.model.MedicalItem.ReadOnly = new Wrapper(impl)
}
