package zio.aws.transcribestreaming.model
import scala.jdk.CollectionConverters._
sealed trait MedicalContentIdentificationType {
  def unwrap: software.amazon.awssdk.services.transcribestreaming.model.MedicalContentIdentificationType
}
object MedicalContentIdentificationType {
  def wrap(
      value: software.amazon.awssdk.services.transcribestreaming.model.MedicalContentIdentificationType
  ): zio.aws.transcribestreaming.model.MedicalContentIdentificationType =
    value match {
      case software.amazon.awssdk.services.transcribestreaming.model.MedicalContentIdentificationType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.transcribestreaming.model.MedicalContentIdentificationType.PHI =>
        val r = PHI
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.transcribestreaming.model.MedicalContentIdentificationType {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.MedicalContentIdentificationType =
      software.amazon.awssdk.services.transcribestreaming.model.MedicalContentIdentificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object PHI
      extends zio.aws.transcribestreaming.model.MedicalContentIdentificationType {
    override def unwrap
        : software.amazon.awssdk.services.transcribestreaming.model.MedicalContentIdentificationType =
      software.amazon.awssdk.services.transcribestreaming.model.MedicalContentIdentificationType.PHI
  }
}
