package zio.aws.transcribestreaming.model
import zio.aws.transcribestreaming.model.primitives.Confidence
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Entity(
    startTime: Option[Double] = None,
    endTime: Option[Double] = None,
    category: Option[String] = None,
    `type`: Option[String] = None,
    content: Option[String] = None,
    confidence: Option[Confidence] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribestreaming.model.Entity = {
    import Entity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribestreaming.model.Entity
      .builder()
      .optionallyWith(startTime.map(value => value: java.lang.Double))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => value: java.lang.Double))(_.endTime)
      .optionallyWith(category.map(value => value: java.lang.String))(
        _.category
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(
        confidence.map(value => Confidence.unwrap(value): java.lang.Double)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.transcribestreaming.model.Entity.ReadOnly =
    zio.aws.transcribestreaming.model.Entity.wrap(buildAwsValue())
}
object Entity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribestreaming.model.Entity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribestreaming.model.Entity =
      zio.aws.transcribestreaming.model.Entity(
        startTime.map(value => value),
        endTime.map(value => value),
        category.map(value => value),
        `type`.map(value => value),
        content.map(value => value),
        confidence.map(value => value)
      )
    def startTime: Option[Double]
    def endTime: Option[Double]
    def category: Option[String]
    def `type`: Option[String]
    def content: Option[String]
    def confidence: Option[Confidence]
    def getStartTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCategory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("category", category)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getConfidence: ZIO[Any, AwsError, Confidence] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Entity
  ) extends zio.aws.transcribestreaming.model.Entity.ReadOnly {
    override val startTime: Option[Double] =
      scala.Option(impl.startTime()).map(value => value: Double)
    override val endTime: Option[Double] =
      scala.Option(impl.endTime()).map(value => value: Double)
    override val category: Option[String] =
      scala.Option(impl.category()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val content: Option[String] =
      scala.Option(impl.content()).map(value => value: String)
    override val confidence: Option[Confidence] = scala
      .Option(impl.confidence())
      .map(value =>
        zio.aws.transcribestreaming.model.primitives.Confidence(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribestreaming.model.Entity
  ): zio.aws.transcribestreaming.model.Entity.ReadOnly = new Wrapper(impl)
}
