package zio.aws.transcribestreaming
import software.amazon.awssdk.services.transcribestreaming.model.{
  AudioStream,
  TranscriptEvent,
  StartStreamTranscriptionResponse,
  StartMedicalStreamTranscriptionResponse,
  StartMedicalStreamTranscriptionResponseHandler,
  TranscriptResultStream,
  StartMedicalStreamTranscriptionRequest,
  MedicalTranscriptResultStream,
  StartStreamTranscriptionResponseHandler,
  StartStreamTranscriptionRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.core.async.SdkPublisher
import zio.aws.transcribestreaming.model.TranscriptEvent.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.transcribestreaming.{
  TranscribeStreamingAsyncClientBuilder,
  TranscribeStreamingAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, ZLayer}
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler
import zio.stream.ZStream
import zio.aws.transcribestreaming.model.AudioEvent
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters._
trait TranscribeStreaming extends AspectSupport[TranscribeStreaming] {
  val api: TranscribeStreamingAsyncClient
  def startMedicalStreamTranscription(
      request: zio.aws.transcribestreaming.model.StartMedicalStreamTranscriptionRequest,
      input: ZStream[Any, AwsError, AudioEvent]
  ): ZStream[Any, AwsError, ReadOnly]
  def startStreamTranscription(
      request: zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest,
      input: ZStream[Any, AwsError, AudioEvent]
  ): ZStream[Any, AwsError, ReadOnly]
}
object TranscribeStreaming {
  val live: ZLayer[AwsConfig, java.lang.Throwable, TranscribeStreaming] =
    customized(identity)
  def customized(
      customization: TranscribeStreamingAsyncClientBuilder => TranscribeStreamingAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, TranscribeStreaming] = managed(
    customization
  ).toLayer
  def managed(
      customization: TranscribeStreamingAsyncClientBuilder => TranscribeStreamingAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, TranscribeStreaming] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- zio.ZIO.executor.toManaged;
    builder = TranscribeStreamingAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        TranscribeStreamingAsyncClient,
        TranscribeStreamingAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        TranscribeStreamingAsyncClient,
        TranscribeStreamingAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = true)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new TranscribeStreamingImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class TranscribeStreamingImpl[R](
      override val api: TranscribeStreamingAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends TranscribeStreaming
      with AwsServiceBase[R] {
    override val serviceName: String = "TranscribeStreaming"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): TranscribeStreamingImpl[R1] =
      new TranscribeStreamingImpl(api, newAspect, r)
    def startMedicalStreamTranscription(
        request: zio.aws.transcribestreaming.model.StartMedicalStreamTranscriptionRequest,
        input: ZStream[Any, AwsError, AudioEvent]
    ): ZStream[Any, AwsError, ReadOnly] = asyncRequestEventInputOutputStream[
      StartMedicalStreamTranscriptionRequest,
      StartMedicalStreamTranscriptionResponse,
      AudioStream,
      StartMedicalStreamTranscriptionResponseHandler,
      MedicalTranscriptResultStream,
      TranscriptEvent
    ](
      "StartMedicalStreamTranscription",
      (
          request: StartMedicalStreamTranscriptionRequest,
          input: Publisher[AudioStream],
          handler: StartMedicalStreamTranscriptionResponseHandler
      ) => api.startMedicalStreamTranscription(request, input, handler),
      (impl: EventStreamResponseHandler[
        StartMedicalStreamTranscriptionResponse,
        MedicalTranscriptResultStream
      ]) =>
        new StartMedicalStreamTranscriptionResponseHandler {
          override def responseReceived(
              response: StartMedicalStreamTranscriptionResponse
          ): Unit = impl.responseReceived(response)
          override def onEventStream(
              publisher: SdkPublisher[MedicalTranscriptResultStream]
          ): Unit = impl.onEventStream(publisher)
          override def exceptionOccurred(throwable: java.lang.Throwable): Unit =
            impl.exceptionOccurred(throwable)
          override def complete(): Unit = impl.complete()
        }
    )(request.buildAwsValue(), input.map(_.buildAwsValue()))
      .map(item => zio.aws.transcribestreaming.model.TranscriptEvent.wrap(item))
      .provideEnvironment(r)
    def startStreamTranscription(
        request: zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest,
        input: ZStream[Any, AwsError, AudioEvent]
    ): ZStream[Any, AwsError, ReadOnly] = asyncRequestEventInputOutputStream[
      StartStreamTranscriptionRequest,
      StartStreamTranscriptionResponse,
      AudioStream,
      StartStreamTranscriptionResponseHandler,
      TranscriptResultStream,
      TranscriptEvent
    ](
      "StartStreamTranscription",
      (
          request: StartStreamTranscriptionRequest,
          input: Publisher[AudioStream],
          handler: StartStreamTranscriptionResponseHandler
      ) => api.startStreamTranscription(request, input, handler),
      (impl: EventStreamResponseHandler[
        StartStreamTranscriptionResponse,
        TranscriptResultStream
      ]) =>
        new StartStreamTranscriptionResponseHandler {
          override def responseReceived(
              response: StartStreamTranscriptionResponse
          ): Unit = impl.responseReceived(response)
          override def onEventStream(
              publisher: SdkPublisher[TranscriptResultStream]
          ): Unit = impl.onEventStream(publisher)
          override def exceptionOccurred(throwable: java.lang.Throwable): Unit =
            impl.exceptionOccurred(throwable)
          override def complete(): Unit = impl.complete()
        }
    )(request.buildAwsValue(), input.map(_.buildAwsValue()))
      .map(item => zio.aws.transcribestreaming.model.TranscriptEvent.wrap(item))
      .provideEnvironment(r)
  }
  def startMedicalStreamTranscription(
      request: zio.aws.transcribestreaming.model.StartMedicalStreamTranscriptionRequest,
      input: ZStream[Any, AwsError, AudioEvent]
  ): ZStream[
    zio.aws.transcribestreaming.TranscribeStreaming,
    AwsError,
    ReadOnly
  ] =
    ZStream.serviceWithStream(_.startMedicalStreamTranscription(request, input))
  def startStreamTranscription(
      request: zio.aws.transcribestreaming.model.StartStreamTranscriptionRequest,
      input: ZStream[Any, AwsError, AudioEvent]
  ): ZStream[
    zio.aws.transcribestreaming.TranscribeStreaming,
    AwsError,
    ReadOnly
  ] = ZStream.serviceWithStream(_.startStreamTranscription(request, input))
}
