package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.DataAccessRoleArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JobExecutionSettings(
    allowDeferredExecution: Optional[Boolean] = Optional.Absent,
    dataAccessRoleArn: Optional[DataAccessRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.JobExecutionSettings = {
    import JobExecutionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.JobExecutionSettings
      .builder()
      .optionallyWith(
        allowDeferredExecution.map(value => value: java.lang.Boolean)
      )(_.allowDeferredExecution)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          DataAccessRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.JobExecutionSettings.ReadOnly =
    zio.aws.transcribe.model.JobExecutionSettings.wrap(buildAwsValue())
}
object JobExecutionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.JobExecutionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.JobExecutionSettings =
      zio.aws.transcribe.model.JobExecutionSettings(
        allowDeferredExecution.map(value => value),
        dataAccessRoleArn.map(value => value)
      )
    def allowDeferredExecution: Optional[Boolean]
    def dataAccessRoleArn: Optional[DataAccessRoleArn]
    def getAllowDeferredExecution: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowDeferredExecution", allowDeferredExecution)
    def getDataAccessRoleArn: ZIO[Any, AwsError, DataAccessRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.JobExecutionSettings
  ) extends zio.aws.transcribe.model.JobExecutionSettings.ReadOnly {
    override val allowDeferredExecution: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowDeferredExecution())
        .map(value => value: Boolean)
    override val dataAccessRoleArn: Optional[DataAccessRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataAccessRoleArn())
        .map(value =>
          zio.aws.transcribe.model.primitives.DataAccessRoleArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.JobExecutionSettings
  ): zio.aws.transcribe.model.JobExecutionSettings.ReadOnly = new Wrapper(impl)
}
