package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  DataAccessRoleArn,
  Uri,
  Phrase,
  VocabularyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateVocabularyRequest(
    vocabularyName: VocabularyName,
    languageCode: zio.aws.transcribe.model.LanguageCode,
    phrases: Optional[Iterable[Phrase]] = Optional.Absent,
    vocabularyFileUri: Optional[Uri] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transcribe.model.Tag]] = Optional.Absent,
    dataAccessRoleArn: Optional[DataAccessRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CreateVocabularyRequest = {
    import CreateVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CreateVocabularyRequest
      .builder()
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        phrases.map(value =>
          value.map { item =>
            Phrase.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phrases)
      .optionallyWith(
        vocabularyFileUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.vocabularyFileUri)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          DataAccessRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.CreateVocabularyRequest.ReadOnly =
    zio.aws.transcribe.model.CreateVocabularyRequest.wrap(buildAwsValue())
}
object CreateVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CreateVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CreateVocabularyRequest =
      zio.aws.transcribe.model.CreateVocabularyRequest(
        vocabularyName,
        languageCode,
        phrases.map(value => value),
        vocabularyFileUri.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataAccessRoleArn.map(value => value)
      )
    def vocabularyName: VocabularyName
    def languageCode: zio.aws.transcribe.model.LanguageCode
    def phrases: Optional[List[Phrase]]
    def vocabularyFileUri: Optional[Uri]
    def tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def dataAccessRoleArn: Optional[DataAccessRoleArn]
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.transcribe.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getPhrases: ZIO[Any, AwsError, List[Phrase]] =
      AwsError.unwrapOptionField("phrases", phrases)
    def getVocabularyFileUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("vocabularyFileUri", vocabularyFileUri)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDataAccessRoleArn: ZIO[Any, AwsError, DataAccessRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CreateVocabularyRequest
  ) extends zio.aws.transcribe.model.CreateVocabularyRequest.ReadOnly {
    override val vocabularyName: VocabularyName =
      zio.aws.transcribe.model.primitives.VocabularyName(impl.vocabularyName())
    override val languageCode: zio.aws.transcribe.model.LanguageCode =
      zio.aws.transcribe.model.LanguageCode.wrap(impl.languageCode())
    override val phrases: Optional[List[Phrase]] = zio.aws.core.internal
      .optionalFromNullable(impl.phrases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.primitives.Phrase(item)
        }.toList
      )
    override val vocabularyFileUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
    override val tags: Optional[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
    override val dataAccessRoleArn: Optional[DataAccessRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataAccessRoleArn())
        .map(value =>
          zio.aws.transcribe.model.primitives.DataAccessRoleArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CreateVocabularyRequest
  ): zio.aws.transcribe.model.CreateVocabularyRequest.ReadOnly = new Wrapper(
    impl
  )
}
