package zio.aws.transcribe.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  IdentifiedLanguageScore,
  FailureReason,
  DateTime,
  TranscriptionJobName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TranscriptionJobSummary(
    transcriptionJobName: Optional[TranscriptionJobName] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    completionTime: Optional[DateTime] = Optional.Absent,
    languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      Optional.Absent,
    transcriptionJobStatus: Optional[
      zio.aws.transcribe.model.TranscriptionJobStatus
    ] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    outputLocationType: Optional[zio.aws.transcribe.model.OutputLocationType] =
      Optional.Absent,
    contentRedaction: Optional[zio.aws.transcribe.model.ContentRedaction] =
      Optional.Absent,
    modelSettings: Optional[zio.aws.transcribe.model.ModelSettings] =
      Optional.Absent,
    identifyLanguage: Optional[Boolean] = Optional.Absent,
    identifyMultipleLanguages: Optional[Boolean] = Optional.Absent,
    identifiedLanguageScore: Optional[IdentifiedLanguageScore] =
      Optional.Absent,
    languageCodes: Optional[
      Iterable[zio.aws.transcribe.model.LanguageCodeItem]
    ] = Optional.Absent,
    toxicityDetection: Optional[
      Iterable[zio.aws.transcribe.model.ToxicityDetectionSettings]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary = {
    import TranscriptionJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary
      .builder()
      .optionallyWith(
        transcriptionJobName.map(value =>
          TranscriptionJobName.unwrap(value): java.lang.String
        )
      )(_.transcriptionJobName)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        completionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(transcriptionJobStatus.map(value => value.unwrap))(
        _.transcriptionJobStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(outputLocationType.map(value => value.unwrap))(
        _.outputLocationType
      )
      .optionallyWith(contentRedaction.map(value => value.buildAwsValue()))(
        _.contentRedaction
      )
      .optionallyWith(modelSettings.map(value => value.buildAwsValue()))(
        _.modelSettings
      )
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        identifyMultipleLanguages.map(value => value: java.lang.Boolean)
      )(_.identifyMultipleLanguages)
      .optionallyWith(
        identifiedLanguageScore.map(value =>
          IdentifiedLanguageScore.unwrap(value): java.lang.Float
        )
      )(_.identifiedLanguageScore)
      .optionallyWith(
        languageCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.languageCodes)
      .optionallyWith(
        toxicityDetection.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.toxicityDetection)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly =
    zio.aws.transcribe.model.TranscriptionJobSummary.wrap(buildAwsValue())
}
object TranscriptionJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.TranscriptionJobSummary =
      zio.aws.transcribe.model.TranscriptionJobSummary(
        transcriptionJobName.map(value => value),
        creationTime.map(value => value),
        startTime.map(value => value),
        completionTime.map(value => value),
        languageCode.map(value => value),
        transcriptionJobStatus.map(value => value),
        failureReason.map(value => value),
        outputLocationType.map(value => value),
        contentRedaction.map(value => value.asEditable),
        modelSettings.map(value => value.asEditable),
        identifyLanguage.map(value => value),
        identifyMultipleLanguages.map(value => value),
        identifiedLanguageScore.map(value => value),
        languageCodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        toxicityDetection.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transcriptionJobName: Optional[TranscriptionJobName]
    def creationTime: Optional[DateTime]
    def startTime: Optional[DateTime]
    def completionTime: Optional[DateTime]
    def languageCode: Optional[zio.aws.transcribe.model.LanguageCode]
    def transcriptionJobStatus
        : Optional[zio.aws.transcribe.model.TranscriptionJobStatus]
    def failureReason: Optional[FailureReason]
    def outputLocationType
        : Optional[zio.aws.transcribe.model.OutputLocationType]
    def contentRedaction
        : Optional[zio.aws.transcribe.model.ContentRedaction.ReadOnly]
    def modelSettings: Optional[zio.aws.transcribe.model.ModelSettings.ReadOnly]
    def identifyLanguage: Optional[Boolean]
    def identifyMultipleLanguages: Optional[Boolean]
    def identifiedLanguageScore: Optional[IdentifiedLanguageScore]
    def languageCodes
        : Optional[List[zio.aws.transcribe.model.LanguageCodeItem.ReadOnly]]
    def toxicityDetection: Optional[
      List[zio.aws.transcribe.model.ToxicityDetectionSettings.ReadOnly]
    ]
    def getTranscriptionJobName: ZIO[Any, AwsError, TranscriptionJobName] =
      AwsError.unwrapOptionField("transcriptionJobName", transcriptionJobName)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCompletionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getTranscriptionJobStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField(
        "transcriptionJobStatus",
        transcriptionJobStatus
      )
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getOutputLocationType
        : ZIO[Any, AwsError, zio.aws.transcribe.model.OutputLocationType] =
      AwsError.unwrapOptionField("outputLocationType", outputLocationType)
    def getContentRedaction: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.ContentRedaction.ReadOnly
    ] = AwsError.unwrapOptionField("contentRedaction", contentRedaction)
    def getModelSettings
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ModelSettings.ReadOnly] =
      AwsError.unwrapOptionField("modelSettings", modelSettings)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getIdentifyMultipleLanguages: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("identifyMultipleLanguages", identifyMultipleLanguages)
    def getIdentifiedLanguageScore
        : ZIO[Any, AwsError, IdentifiedLanguageScore] = AwsError
      .unwrapOptionField("identifiedLanguageScore", identifiedLanguageScore)
    def getLanguageCodes: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.LanguageCodeItem.ReadOnly
    ]] = AwsError.unwrapOptionField("languageCodes", languageCodes)
    def getToxicityDetection: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.ToxicityDetectionSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("toxicityDetection", toxicityDetection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary
  ) extends zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly {
    override val transcriptionJobName: Optional[TranscriptionJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptionJobName())
        .map(value =>
          zio.aws.transcribe.model.primitives.TranscriptionJobName(value)
        )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val completionTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.completionTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val languageCode: Optional[zio.aws.transcribe.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val transcriptionJobStatus
        : Optional[zio.aws.transcribe.model.TranscriptionJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptionJobStatus())
        .map(value =>
          zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value)
        )
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val outputLocationType
        : Optional[zio.aws.transcribe.model.OutputLocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputLocationType())
        .map(value => zio.aws.transcribe.model.OutputLocationType.wrap(value))
    override val contentRedaction
        : Optional[zio.aws.transcribe.model.ContentRedaction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRedaction())
        .map(value => zio.aws.transcribe.model.ContentRedaction.wrap(value))
    override val modelSettings
        : Optional[zio.aws.transcribe.model.ModelSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelSettings())
        .map(value => zio.aws.transcribe.model.ModelSettings.wrap(value))
    override val identifyLanguage: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.identifyLanguage())
      .map(value => value: Boolean)
    override val identifyMultipleLanguages: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifyMultipleLanguages())
        .map(value => value: Boolean)
    override val identifiedLanguageScore: Optional[IdentifiedLanguageScore] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifiedLanguageScore())
        .map(value =>
          zio.aws.transcribe.model.primitives.IdentifiedLanguageScore(value)
        )
    override val languageCodes
        : Optional[List[zio.aws.transcribe.model.LanguageCodeItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.LanguageCodeItem.wrap(item)
          }.toList
        )
    override val toxicityDetection: Optional[
      List[zio.aws.transcribe.model.ToxicityDetectionSettings.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.toxicityDetection())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.ToxicityDetectionSettings.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary
  ): zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
